/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.annotations.VisibleForTesting;
import java.util.Map;

public class Event {
    long timestamp;
    String uuid;
    @JsonProperty(value="entity_id")
    String entityId;
    String key;
    Number quantity;
    Number revenue;
    Map<String, ?> tags;
    String type;
    Number value;

    @VisibleForTesting
    public Event() {
    }

    public Event(long timestamp, String uuid, String entityId, String key, Number quantity, Number revenue, Map<String, ?> tags, String type, Number value) {
        this.timestamp = timestamp;
        this.uuid = uuid;
        this.entityId = entityId;
        this.key = key;
        this.quantity = quantity;
        this.revenue = revenue;
        this.tags = tags;
        this.type = type;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Number getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Number quantity) {
        this.quantity = quantity;
    }

    public Number getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Number revenue) {
        this.revenue = revenue;
    }

    public Map<String, ?> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, ?> tags) {
        this.tags = tags;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.timestamp != event.timestamp) {
            return false;
        }
        if (!this.uuid.equals(event.uuid)) {
            return false;
        }
        if (this.entityId != null ? !this.entityId.equals(event.entityId) : event.entityId != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(event.key) : event.key != null) {
            return false;
        }
        if (this.quantity != null ? !this.quantity.equals(event.quantity) : event.quantity != null) {
            return false;
        }
        if (this.revenue != null ? !this.revenue.equals(event.revenue) : event.revenue != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(event.tags) : event.tags != null) {
            return false;
        }
        if (!this.type.equals(event.type)) {
            return false;
        }
        return this.value != null ? this.value.equals(event.value) : event.value == null;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.uuid.hashCode();
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.quantity != null ? this.quantity.hashCode() : 0);
        result = 31 * result + (this.revenue != null ? this.revenue.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private long timestamp;
        private String uuid;
        private String entityId;
        private String key;
        private Number quantity = null;
        private Number revenue = null;
        private Map<String, ?> tags = null;
        private String type;
        private Number value = null;

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setEntityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setQuantity(Number quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder setRevenue(Number revenue) {
            this.revenue = revenue;
            return this;
        }

        public Builder setTags(Map<String, ?> tags) {
            this.tags = tags;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setValue(Number value) {
            this.value = value;
            return this;
        }

        public Event build() {
            return new Event(this.timestamp, this.uuid, this.entityId, this.key, this.quantity, this.revenue, this.tags, this.type, this.value);
        }
    }
}

