/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.annotations.VisibleForTesting;

public class Decision {
    @JsonProperty(value="campaign_id")
    String campaignId;
    @JsonProperty(value="experiment_id")
    String experimentId;
    @JsonProperty(value="variation_id")
    String variationId;
    @JsonProperty(value="is_campaign_holdback")
    boolean isCampaignHoldback;

    @VisibleForTesting
    public Decision() {
    }

    public Decision(String campaignId, String experimentId, String variationId, boolean isCampaignHoldback) {
        this.campaignId = campaignId;
        this.experimentId = experimentId;
        this.variationId = variationId;
        this.isCampaignHoldback = isCampaignHoldback;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public boolean getIsCampaignHoldback() {
        return this.isCampaignHoldback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decision that = (Decision)o;
        if (this.isCampaignHoldback != that.isCampaignHoldback) {
            return false;
        }
        if (!this.campaignId.equals(that.campaignId)) {
            return false;
        }
        if (!this.experimentId.equals(that.experimentId)) {
            return false;
        }
        return this.variationId.equals(that.variationId);
    }

    public int hashCode() {
        int result = this.campaignId.hashCode();
        result = 31 * result + this.experimentId.hashCode();
        result = 31 * result + this.variationId.hashCode();
        result = 31 * result + (this.isCampaignHoldback ? 1 : 0);
        return result;
    }

    public static class Builder {
        private String campaignId;
        private String experimentId;
        private String variationId;
        private boolean isCampaignHoldback;

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setExperimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public Builder setVariationId(String variationId) {
            this.variationId = variationId;
            return this;
        }

        public Builder setIsCampaignHoldback(boolean isCampaignHoldback) {
            this.isCampaignHoldback = isCampaignHoldback;
            return this;
        }

        public Decision build() {
            return new Decision(this.campaignId, this.experimentId, this.variationId, this.isCampaignHoldback);
        }
    }
}

