/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.payload.Attribute;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.event.internal.payload.Snapshot;
import com.optimizely.ab.event.internal.payload.Visitor;
import com.optimizely.ab.internal.AttributesUtil;
import com.optimizely.ab.internal.ControlAttribute;
import com.optimizely.ab.internal.EventTagUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventFactory.class);
    static final String EVENT_ENDPOINT = "https://logx.optimizely.com/v1/events";
    static final String ACTIVATE_EVENT_KEY = "campaign_activated";
    @VisibleForTesting
    public final String clientVersion;
    @VisibleForTesting
    public final EventBatch.ClientEngine clientEngine;

    public EventFactory() {
        this(EventBatch.ClientEngine.JAVA_SDK, BuildVersionInfo.VERSION);
    }

    public EventFactory(EventBatch.ClientEngine clientEngine, String clientVersion) {
        this.clientEngine = clientEngine;
        this.clientVersion = clientVersion;
    }

    public LogEvent createImpressionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment activatedExperiment, @Nonnull Variation variation, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        Decision decision = new Decision.Builder().setCampaignId(activatedExperiment.getLayerId()).setExperimentId(activatedExperiment.getId()).setVariationId(variation.getId()).setIsCampaignHoldback(false).build();
        Event impressionEvent = new Event.Builder().setTimestamp(System.currentTimeMillis()).setUuid(UUID.randomUUID().toString()).setEntityId(activatedExperiment.getLayerId()).setKey(ACTIVATE_EVENT_KEY).setType(ACTIVATE_EVENT_KEY).build();
        Snapshot snapshot = new Snapshot.Builder().setDecisions(Collections.singletonList(decision)).setEvents(Collections.singletonList(impressionEvent)).build();
        Visitor visitor = new Visitor.Builder().setVisitorId(userId).setAttributes(this.buildAttributeList(projectConfig, attributes)).setSnapshots(Collections.singletonList(snapshot)).build();
        EventBatch eventBatch = new EventBatch.Builder().setClientName(this.clientEngine.getClientEngineValue()).setClientVersion(this.clientVersion).setAccountId(projectConfig.getAccountId()).setVisitors(Collections.singletonList(visitor)).setAnonymizeIp(projectConfig.getAnonymizeIP()).setProjectId(projectConfig.getProjectId()).setRevision(projectConfig.getRevision()).build();
        return new LogEvent(LogEvent.RequestMethod.POST, EVENT_ENDPOINT, Collections.emptyMap(), eventBatch);
    }

    public LogEvent createConversionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull String userId, @Nonnull String eventId, @Nonnull String eventName, @Nonnull Map<String, ?> attributes, @Nonnull Map<String, ?> eventTags) {
        EventType eventType = projectConfig.getEventNameMapping().get(eventName);
        Event conversionEvent = new Event.Builder().setTimestamp(System.currentTimeMillis()).setUuid(UUID.randomUUID().toString()).setEntityId(eventType.getId()).setKey(eventType.getKey()).setRevenue(EventTagUtils.getRevenueValue(eventTags)).setTags(eventTags).setType(eventType.getKey()).setValue(EventTagUtils.getNumericValue(eventTags)).build();
        Snapshot snapshot = new Snapshot.Builder().setEvents(Collections.singletonList(conversionEvent)).build();
        Visitor visitor = new Visitor.Builder().setVisitorId(userId).setAttributes(this.buildAttributeList(projectConfig, attributes)).setSnapshots(Collections.singletonList(snapshot)).build();
        EventBatch eventBatch = new EventBatch.Builder().setClientName(this.clientEngine.getClientEngineValue()).setClientVersion(this.clientVersion).setAccountId(projectConfig.getAccountId()).setVisitors(Collections.singletonList(visitor)).setAnonymizeIp(projectConfig.getAnonymizeIP()).setProjectId(projectConfig.getProjectId()).setRevision(projectConfig.getRevision()).build();
        return new LogEvent(LogEvent.RequestMethod.POST, EVENT_ENDPOINT, Collections.emptyMap(), eventBatch);
    }

    private List<Attribute> buildAttributeList(ProjectConfig projectConfig, Map<String, ?> attributes) {
        ArrayList<Attribute> attributesList = new ArrayList<Attribute>();
        if (attributes != null) {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                String attributeId;
                if (entry.getKey().isEmpty() || entry.getValue() == null || !(entry.getValue() instanceof String) && !(entry.getValue() instanceof Boolean) && !AttributesUtil.isValidNumber(entry.getValue()) || (attributeId = projectConfig.getAttributeId(projectConfig, entry.getKey())) == null) continue;
                Attribute attribute = new Attribute.Builder().setEntityId(attributeId).setKey(entry.getKey()).setType("custom").setValue(entry.getValue()).build();
                attributesList.add(attribute);
            }
        }
        if (projectConfig.getBotFiltering() != null) {
            Attribute attribute = new Attribute.Builder().setEntityId(ControlAttribute.BOT_FILTERING_ATTRIBUTE.toString()).setKey(ControlAttribute.BOT_FILTERING_ATTRIBUTE.toString()).setType("custom").setValue(projectConfig.getBotFiltering()).build();
            attributesList.add(attribute);
        }
        return attributesList;
    }
}

