/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event;

import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.event.internal.serializer.DefaultJsonSerializer;
import com.optimizely.ab.event.internal.serializer.Serializer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LogEvent {
    private final RequestMethod requestMethod;
    private final String endpointUrl;
    private final Map<String, String> requestParams;
    private final EventBatch eventBatch;

    public LogEvent(@Nonnull RequestMethod requestMethod, @Nonnull String endpointUrl, @Nonnull Map<String, String> requestParams, EventBatch eventBatch) {
        this.requestMethod = requestMethod;
        this.endpointUrl = endpointUrl;
        this.requestParams = requestParams;
        this.eventBatch = eventBatch;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public Map<String, String> getRequestParams() {
        return this.requestParams;
    }

    public String getBody() {
        if (this.eventBatch == null) {
            return "";
        }
        Serializer serializer = DefaultJsonSerializer.getInstance();
        return serializer.serialize(this.eventBatch);
    }

    public String toString() {
        return "LogEvent{requestMethod=" + (Object)((Object)this.requestMethod) + ", endpointUrl='" + this.endpointUrl + '\'' + ", requestParams=" + this.requestParams + ", body='" + this.getBody() + '\'' + '}';
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

