/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.TypedAudience;
import com.optimizely.ab.config.parser.AudienceJacksonDeserializer;
import com.optimizely.ab.config.parser.ConditionJacksonDeserializer;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.ProjectConfigJacksonDeserializer;
import com.optimizely.ab.config.parser.TypedAudienceJacksonDeserializer;
import javax.annotation.Nonnull;

final class JacksonConfigParser
implements ConfigParser {
    private ObjectMapper objectMapper;

    public JacksonConfigParser() {
        this(new ObjectMapper());
    }

    JacksonConfigParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.objectMapper.registerModule((Module)new ProjectConfigModule());
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        try {
            return (ProjectConfig)this.objectMapper.readValue(json, ProjectConfig.class);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    class ProjectConfigModule
    extends SimpleModule {
        private static final String NAME = "ProjectConfigModule";

        public ProjectConfigModule() {
            super(NAME);
            this.addDeserializer(ProjectConfig.class, new ProjectConfigJacksonDeserializer());
            this.addDeserializer(Audience.class, new AudienceJacksonDeserializer(JacksonConfigParser.this.objectMapper));
            this.addDeserializer(TypedAudience.class, new TypedAudienceJacksonDeserializer(JacksonConfigParser.this.objectMapper));
            this.addDeserializer(Condition.class, new ConditionJacksonDeserializer(JacksonConfigParser.this.objectMapper));
        }
    }
}

