/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience.match;

import com.optimizely.ab.config.audience.match.DefaultMatchForLegacyAttributes;
import com.optimizely.ab.config.audience.match.ExactMatch;
import com.optimizely.ab.config.audience.match.ExactNumberMatch;
import com.optimizely.ab.config.audience.match.ExistsMatch;
import com.optimizely.ab.config.audience.match.GTMatch;
import com.optimizely.ab.config.audience.match.LTMatch;
import com.optimizely.ab.config.audience.match.Match;
import com.optimizely.ab.config.audience.match.SubstringMatch;
import com.optimizely.ab.config.audience.match.UnexpectedValueTypeException;
import com.optimizely.ab.config.audience.match.UnknownMatchTypeException;
import com.optimizely.ab.internal.AttributesUtil;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchType {
    public static final Logger logger = LoggerFactory.getLogger(MatchType.class);
    private String matchType;
    private Match matcher;

    public static MatchType getMatchType(String matchType, Object conditionValue) throws UnexpectedValueTypeException, UnknownMatchTypeException {
        if (matchType == null) {
            matchType = "legacy_custom_attribute";
        }
        switch (matchType) {
            case "exists": {
                return new MatchType(matchType, new ExistsMatch(conditionValue));
            }
            case "exact": {
                if (conditionValue instanceof String) {
                    return new MatchType(matchType, new ExactMatch<String>((String)conditionValue));
                }
                if (AttributesUtil.isValidNumber(conditionValue)) {
                    return new MatchType(matchType, new ExactNumberMatch((Number)conditionValue));
                }
                if (!(conditionValue instanceof Boolean)) break;
                return new MatchType(matchType, new ExactMatch<Boolean>((Boolean)conditionValue));
            }
            case "substring": {
                if (!(conditionValue instanceof String)) break;
                return new MatchType(matchType, new SubstringMatch((String)conditionValue));
            }
            case "gt": {
                if (!AttributesUtil.isValidNumber(conditionValue)) break;
                return new MatchType(matchType, new GTMatch((Number)conditionValue));
            }
            case "lt": {
                if (!AttributesUtil.isValidNumber(conditionValue)) break;
                return new MatchType(matchType, new LTMatch((Number)conditionValue));
            }
            case "legacy_custom_attribute": {
                if (!(conditionValue instanceof String)) break;
                return new MatchType(matchType, new DefaultMatchForLegacyAttributes<String>((String)conditionValue));
            }
            default: {
                throw new UnknownMatchTypeException();
            }
        }
        throw new UnexpectedValueTypeException();
    }

    private MatchType(String type, Match matcher) {
        this.matchType = type;
        this.matcher = matcher;
    }

    @Nonnull
    public Match getMatcher() {
        return this.matcher;
    }

    public String toString() {
        return this.matchType;
    }
}

