/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience;

import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Condition;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OrCondition<T>
implements Condition<T> {
    private final List<Condition> conditions;

    public OrCondition(@Nonnull List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    @Nullable
    public Boolean evaluate(ProjectConfig config, Map<String, ?> attributes) {
        if (this.conditions == null) {
            return null;
        }
        boolean foundNull = false;
        for (Condition condition : this.conditions) {
            Boolean conditionEval = condition.evaluate(config, attributes);
            if (conditionEval == null) {
                foundNull = true;
                continue;
            }
            if (!conditionEval.booleanValue()) continue;
            return true;
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[or, ");
        for (int i = 0; i < this.conditions.size(); ++i) {
            s.append(this.conditions.get(i));
            if (i >= this.conditions.size() - 1) continue;
            s.append(", ");
        }
        s.append("]");
        return s.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof OrCondition)) {
            return false;
        }
        OrCondition otherOrCondition = (OrCondition)other;
        return this.conditions.equals(otherOrCondition.getConditions());
    }

    public int hashCode() {
        return this.conditions.hashCode();
    }
}

