/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AudienceIdCondition<T>
implements Condition<T> {
    private Audience audience;
    private final String audienceId;
    private static final Logger logger = LoggerFactory.getLogger((String)"AudienceIdCondition");

    @JsonCreator
    public AudienceIdCondition(String audienceId) {
        this.audienceId = audienceId;
    }

    public Audience getAudience() {
        return this.audience;
    }

    public void setAudience(Audience audience) {
        this.audience = audience;
    }

    public String getAudienceId() {
        return this.audienceId;
    }

    @Override
    @Nullable
    public Boolean evaluate(ProjectConfig config, Map<String, ?> attributes) {
        if (config != null) {
            this.audience = config.getAudienceIdMapping().get(this.audienceId);
        }
        if (this.audience == null) {
            logger.error("Audience {} could not be found.", (Object)this.audienceId);
            return null;
        }
        logger.debug("Starting to evaluate audience {} with conditions: \"{}\"", (Object)this.audience.getName(), (Object)this.audience.getConditions());
        Boolean result = this.audience.getConditions().evaluate(config, attributes);
        logger.info("Audience {} evaluated to {}", (Object)this.audience.getName(), (Object)result);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceIdCondition condition = (AudienceIdCondition)o;
        return (this.audience == null ? null == condition.audience : this.audience.getId().equals(condition.audience != null ? condition.audience.getId() : null)) && (this.audienceId == null ? null == condition.audienceId : this.audienceId.equals(condition.audienceId));
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.audienceId);
    }

    public String toString() {
        return this.audienceId;
    }
}

