/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.IdMapped;
import com.optimizely.ab.config.TrafficAllocation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class Group
implements IdMapped {
    private final String id;
    private final String policy;
    private final List<TrafficAllocation> trafficAllocation;
    private final List<Experiment> experiments;
    public static final String RANDOM_POLICY = "random";

    @JsonCreator
    public Group(@JsonProperty(value="id") String id, @JsonProperty(value="policy") String policy, @JsonProperty(value="experiments") List<Experiment> experiments, @JsonProperty(value="trafficAllocation") List<TrafficAllocation> trafficAllocation) {
        this.id = id;
        this.policy = policy;
        this.trafficAllocation = trafficAllocation;
        this.experiments = new ArrayList<Experiment>(experiments.size());
        for (Experiment experiment : experiments) {
            if (id != null && !id.equals(experiment.getGroupId())) {
                experiment = new Experiment(experiment.getId(), experiment.getKey(), experiment.getStatus(), experiment.getLayerId(), experiment.getAudienceIds(), experiment.getAudienceConditions(), experiment.getVariations(), experiment.getUserIdToVariationKeyMap(), experiment.getTrafficAllocation(), id);
            }
            this.experiments.add(experiment);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPolicy() {
        return this.policy;
    }

    public List<TrafficAllocation> getTrafficAllocation() {
        return this.trafficAllocation;
    }

    public List<Experiment> getExperiments() {
        return this.experiments;
    }

    public String toString() {
        return "Group{id='" + this.id + '\'' + ", policy='" + this.policy + '\'' + ", experiments=" + this.experiments + ", trafficAllocation=" + this.trafficAllocation + '}';
    }
}

