/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.optimizely.ab.config.IdKeyMapped;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureVariable
implements IdKeyMapped {
    private final String id;
    private final String key;
    private final String defaultValue;
    private final VariableType type;
    @Nullable
    private final VariableStatus status;

    @JsonCreator
    public FeatureVariable(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="defaultValue") String defaultValue, @JsonProperty(value="status") VariableStatus status, @JsonProperty(value="type") VariableType type) {
        this.id = id;
        this.key = key;
        this.defaultValue = defaultValue;
        this.status = status;
        this.type = type;
    }

    @Nullable
    public VariableStatus getStatus() {
        return this.status;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public VariableType getType() {
        return this.type;
    }

    public String toString() {
        return "FeatureVariable{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", type=" + (Object)((Object)this.type) + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureVariable variable = (FeatureVariable)o;
        if (!this.id.equals(variable.id)) {
            return false;
        }
        if (!this.key.equals(variable.key)) {
            return false;
        }
        if (!this.defaultValue.equals(variable.defaultValue)) {
            return false;
        }
        if (this.type != variable.type) {
            return false;
        }
        return this.status == variable.status;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.defaultValue.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public static enum VariableType {
        BOOLEAN("boolean"),
        INTEGER("integer"),
        STRING("string"),
        DOUBLE("double");

        private final String variableType;

        private VariableType(String variableType) {
            this.variableType = variableType;
        }

        @JsonValue
        public String getVariableType() {
            return this.variableType;
        }

        public static VariableType fromString(String variableTypeString) {
            if (variableTypeString != null) {
                for (VariableType variableTypeEnum : VariableType.values()) {
                    if (!variableTypeString.equals(variableTypeEnum.getVariableType())) continue;
                    return variableTypeEnum;
                }
            }
            return null;
        }
    }

    public static enum VariableStatus {
        ACTIVE("active"),
        ARCHIVED("archived");

        private final String variableStatus;

        private VariableStatus(String variableStatus) {
            this.variableStatus = variableStatus;
        }

        @JsonValue
        public String getVariableStatus() {
            return this.variableStatus;
        }

        public static VariableStatus fromString(String variableStatusString) {
            if (variableStatusString != null) {
                for (VariableStatus variableStatusEnum : VariableStatus.values()) {
                    if (!variableStatusString.equals(variableStatusEnum.getVariableStatus())) continue;
                    return variableStatusEnum;
                }
            }
            return null;
        }
    }
}

