/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.config.IdKeyMapped;
import com.optimizely.ab.config.ProjectConfigUtils;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class Experiment
implements IdKeyMapped {
    private final String id;
    private final String key;
    private final String status;
    private final String layerId;
    private final String groupId;
    private final List<String> audienceIds;
    private final Condition<AudienceIdCondition> audienceConditions;
    private final List<Variation> variations;
    private final List<TrafficAllocation> trafficAllocation;
    private final Map<String, Variation> variationKeyToVariationMap;
    private final Map<String, Variation> variationIdToVariationMap;
    private final Map<String, String> userIdToVariationKeyMap;

    @JsonCreator
    public Experiment(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="status") String status, @JsonProperty(value="layerId") String layerId, @JsonProperty(value="audienceIds") List<String> audienceIds, @JsonProperty(value="audienceConditions") Condition audienceConditions, @JsonProperty(value="variations") List<Variation> variations, @JsonProperty(value="forcedVariations") Map<String, String> userIdToVariationKeyMap, @JsonProperty(value="trafficAllocation") List<TrafficAllocation> trafficAllocation) {
        this(id, key, status, layerId, audienceIds, audienceConditions, variations, userIdToVariationKeyMap, trafficAllocation, "");
    }

    public Experiment(@Nonnull String id, @Nonnull String key, @Nullable String status, @Nullable String layerId, @Nonnull List<String> audienceIds, @Nullable Condition audienceConditions, @Nonnull List<Variation> variations, @Nonnull Map<String, String> userIdToVariationKeyMap, @Nonnull List<TrafficAllocation> trafficAllocation, @Nonnull String groupId) {
        this.id = id;
        this.key = key;
        this.status = status == null ? ExperimentStatus.NOT_STARTED.toString() : status;
        this.layerId = layerId;
        this.audienceIds = Collections.unmodifiableList(audienceIds);
        this.audienceConditions = audienceConditions;
        this.variations = Collections.unmodifiableList(variations);
        this.trafficAllocation = Collections.unmodifiableList(trafficAllocation);
        this.groupId = groupId;
        this.userIdToVariationKeyMap = userIdToVariationKeyMap;
        this.variationKeyToVariationMap = ProjectConfigUtils.generateNameMapping(variations);
        this.variationIdToVariationMap = ProjectConfigUtils.generateIdMapping(variations);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getStatus() {
        return this.status;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public List<String> getAudienceIds() {
        return this.audienceIds;
    }

    public Condition getAudienceConditions() {
        return this.audienceConditions;
    }

    public List<Variation> getVariations() {
        return this.variations;
    }

    public Map<String, Variation> getVariationKeyToVariationMap() {
        return this.variationKeyToVariationMap;
    }

    public Map<String, Variation> getVariationIdToVariationMap() {
        return this.variationIdToVariationMap;
    }

    public Map<String, String> getUserIdToVariationKeyMap() {
        return this.userIdToVariationKeyMap;
    }

    public List<TrafficAllocation> getTrafficAllocation() {
        return this.trafficAllocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isActive() {
        return this.status.equals(ExperimentStatus.RUNNING.toString()) || this.status.equals(ExperimentStatus.LAUNCHED.toString());
    }

    public boolean isRunning() {
        return this.status.equals(ExperimentStatus.RUNNING.toString());
    }

    public boolean isLaunched() {
        return this.status.equals(ExperimentStatus.LAUNCHED.toString());
    }

    public String toString() {
        return "Experiment{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", groupId='" + this.groupId + '\'' + ", status='" + this.status + '\'' + ", audienceIds=" + this.audienceIds + ", audienceConditions=" + this.audienceConditions + ", variations=" + this.variations + ", variationKeyToVariationMap=" + this.variationKeyToVariationMap + ", userIdToVariationKeyMap=" + this.userIdToVariationKeyMap + ", trafficAllocation=" + this.trafficAllocation + '}';
    }

    public static enum ExperimentStatus {
        RUNNING("Running"),
        LAUNCHED("Launched"),
        PAUSED("Paused"),
        NOT_STARTED("Not started"),
        ARCHIVED("Archived");

        private final String experimentStatus;

        private ExperimentStatus(String experimentStatus) {
            this.experimentStatus = experimentStatus;
        }

        public String toString() {
            return this.experimentStatus;
        }
    }
}

