/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.UnknownExperimentException;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.bucketing.Bucketer;
import com.optimizely.ab.bucketing.DecisionService;
import com.optimizely.ab.bucketing.FeatureDecision;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.error.NoOpErrorHandler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.EventFactory;
import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.notification.NotificationCenter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Optimizely {
    private static final Logger logger = LoggerFactory.getLogger(Optimizely.class);
    @VisibleForTesting
    DecisionService decisionService;
    @VisibleForTesting
    final EventFactory eventFactory;
    @VisibleForTesting
    ProjectConfig projectConfig;
    @VisibleForTesting
    final EventHandler eventHandler;
    @VisibleForTesting
    final ErrorHandler errorHandler;
    private boolean isValid;
    public final NotificationCenter notificationCenter = new NotificationCenter();
    @Nullable
    private final UserProfileService userProfileService;

    private Optimizely(@Nonnull EventHandler eventHandler, @Nonnull EventFactory eventFactory, @Nonnull ErrorHandler errorHandler, @Nullable DecisionService decisionService, @Nullable UserProfileService userProfileService) {
        this.decisionService = decisionService;
        this.eventHandler = eventHandler;
        this.eventFactory = eventFactory;
        this.errorHandler = errorHandler;
        this.userProfileService = userProfileService;
    }

    @VisibleForTesting
    void initialize(@Nonnull String datafile, @Nullable ProjectConfig projectConfig) {
        if (projectConfig == null) {
            try {
                projectConfig = new ProjectConfig.Builder().withDatafile(datafile).build();
                this.isValid = true;
                logger.info("Datafile is valid");
            }
            catch (ConfigParseException ex) {
                logger.error("Unable to parse the datafile", (Throwable)ex);
                logger.info("Datafile is invalid");
                this.errorHandler.handleError(new OptimizelyRuntimeException(ex));
            }
        } else {
            this.isValid = true;
        }
        this.projectConfig = projectConfig;
        if (this.decisionService == null) {
            Bucketer bucketer = new Bucketer(projectConfig);
            this.decisionService = new DecisionService(bucketer, this.errorHandler, projectConfig, this.userProfileService);
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.activate(experimentKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownExperimentException {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing activate call.");
            return null;
        }
        if (experimentKey == null) {
            logger.error("The experimentKey parameter must be nonnull.");
            return null;
        }
        if (!this.validateUserId(userId)) {
            logger.info("Not activating user for experiment \"{}\".", (Object)experimentKey);
            return null;
        }
        ProjectConfig currentConfig = this.getProjectConfig();
        Experiment experiment = currentConfig.getExperimentForKey(experimentKey, this.errorHandler);
        if (experiment == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experimentKey);
            return null;
        }
        return this.activate(currentConfig, experiment, userId, attributes);
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId) {
        return this.activate(experiment, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        ProjectConfig currentConfig = this.getProjectConfig();
        return this.activate(currentConfig, experiment, userId, attributes);
    }

    @Nullable
    private Variation activate(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing activate call.");
            return null;
        }
        if (!this.validateUserId(userId)) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            return null;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        Variation variation = this.decisionService.getVariation(experiment, userId, copiedAttributes);
        if (variation == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            return null;
        }
        this.sendImpression(projectConfig, experiment, userId, copiedAttributes, variation);
        return variation;
    }

    private void sendImpression(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes, @Nonnull Variation variation) {
        if (experiment.isRunning()) {
            LogEvent impressionEvent = this.eventFactory.createImpressionEvent(projectConfig, experiment, variation, userId, filteredAttributes);
            logger.info("Activating user \"{}\" in experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching impression event to URL {} with params {} and payload \"{}\".", new Object[]{impressionEvent.getEndpointUrl(), impressionEvent.getRequestParams(), impressionEvent.getBody()});
            }
            try {
                this.eventHandler.dispatchEvent(impressionEvent);
            }
            catch (Exception e) {
                logger.error("Unexpected exception in event dispatcher", (Throwable)e);
            }
            this.notificationCenter.sendNotifications(NotificationCenter.NotificationType.Activate, experiment, userId, filteredAttributes, variation, impressionEvent);
        } else {
            logger.info("Experiment has \"Launched\" status so not dispatching event during activation.");
        }
    }

    public void track(@Nonnull String eventName, @Nonnull String userId) throws UnknownEventTypeException {
        this.track(eventName, userId, Collections.emptyMap(), Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownEventTypeException {
        this.track(eventName, userId, attributes, Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull Map<String, ?> eventTags) throws UnknownEventTypeException {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing track call.");
            return;
        }
        if (!this.validateUserId(userId)) {
            logger.info("Not tracking event \"{}\".", (Object)eventName);
            return;
        }
        if (eventName == null || eventName.trim().isEmpty()) {
            logger.error("Event Key is null or empty when non-null and non-empty String was expected.");
            logger.info("Not tracking event for user \"{}\".", (Object)userId);
            return;
        }
        ProjectConfig currentConfig = this.getProjectConfig();
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        EventType eventType = currentConfig.getEventTypeForName(eventName, this.errorHandler);
        if (eventType == null) {
            logger.info("Not tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
            return;
        }
        if (eventTags == null) {
            logger.warn("Event tags is null when non-null was expected. Defaulting to an empty event tags map.");
        }
        LogEvent conversionEvent = this.eventFactory.createConversionEvent(this.projectConfig, userId, eventType.getId(), eventType.getKey(), copiedAttributes, eventTags);
        logger.info("Tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
        if (logger.isDebugEnabled()) {
            logger.debug("Dispatching conversion event to URL {} with params {} and payload \"{}\".", new Object[]{conversionEvent.getEndpointUrl(), conversionEvent.getRequestParams(), conversionEvent.getBody()});
        }
        try {
            this.eventHandler.dispatchEvent(conversionEvent);
        }
        catch (Exception e) {
            logger.error("Unexpected exception in event dispatcher", (Throwable)e);
        }
        this.notificationCenter.sendNotifications(NotificationCenter.NotificationType.Track, eventName, userId, copiedAttributes, eventTags, conversionEvent);
    }

    @Nonnull
    public Boolean isFeatureEnabled(@Nonnull String featureKey, @Nonnull String userId) {
        return this.isFeatureEnabled(featureKey, userId, Collections.emptyMap());
    }

    @Nonnull
    public Boolean isFeatureEnabled(@Nonnull String featureKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return false;
        }
        if (featureKey == null) {
            logger.warn("The featureKey parameter must be nonnull.");
            return false;
        }
        if (userId == null) {
            logger.warn("The userId parameter must be nonnull.");
            return false;
        }
        FeatureFlag featureFlag = this.projectConfig.getFeatureKeyMapping().get(featureKey);
        if (featureFlag == null) {
            logger.info("No feature flag was found for key \"{}\".", (Object)featureKey);
            return false;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        FeatureDecision featureDecision = this.decisionService.getVariationForFeature(featureFlag, userId, copiedAttributes);
        if (featureDecision.variation != null) {
            if (featureDecision.decisionSource.equals((Object)FeatureDecision.DecisionSource.EXPERIMENT)) {
                this.sendImpression(this.projectConfig, featureDecision.experiment, userId, copiedAttributes, featureDecision.variation);
            } else {
                logger.info("The user \"{}\" is not included in an experiment for feature \"{}\".", (Object)userId, (Object)featureKey);
            }
            if (featureDecision.variation.getFeatureEnabled().booleanValue()) {
                logger.info("Feature \"{}\" is enabled for user \"{}\".", (Object)featureKey, (Object)userId);
                return true;
            }
        }
        logger.info("Feature \"{}\" is not enabled for user \"{}\".", (Object)featureKey, (Object)userId);
        return false;
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableBoolean(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getFeatureVariableBoolean call.");
            return null;
        }
        String variableValue = this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, FeatureVariable.VariableType.BOOLEAN);
        if (variableValue != null) {
            return Boolean.parseBoolean(variableValue);
        }
        return null;
    }

    @Nullable
    public Double getFeatureVariableDouble(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableDouble(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Double getFeatureVariableDouble(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getFeatureVariableDouble call.");
            return null;
        }
        String variableValue = this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, FeatureVariable.VariableType.DOUBLE);
        if (variableValue != null) {
            try {
                return Double.parseDouble(variableValue);
            }
            catch (NumberFormatException exception) {
                logger.error("NumberFormatException while trying to parse \"" + variableValue + "\" as Double. " + exception);
            }
        }
        return null;
    }

    @Nullable
    public Integer getFeatureVariableInteger(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableInteger(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Integer getFeatureVariableInteger(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getFeatureVariableInteger call.");
            return null;
        }
        String variableValue = this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, FeatureVariable.VariableType.INTEGER);
        if (variableValue != null) {
            try {
                return Integer.parseInt(variableValue);
            }
            catch (NumberFormatException exception) {
                logger.error("NumberFormatException while trying to parse \"" + variableValue + "\" as Integer. " + exception.toString());
            }
        }
        return null;
    }

    @Nullable
    public String getFeatureVariableString(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableString(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public String getFeatureVariableString(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getFeatureVariableString call.");
            return null;
        }
        return this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, FeatureVariable.VariableType.STRING);
    }

    @VisibleForTesting
    String getFeatureVariableValueForType(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull FeatureVariable.VariableType variableType) {
        if (featureKey == null) {
            logger.warn("The featureKey parameter must be nonnull.");
            return null;
        }
        if (variableKey == null) {
            logger.warn("The variableKey parameter must be nonnull.");
            return null;
        }
        if (userId == null) {
            logger.warn("The userId parameter must be nonnull.");
            return null;
        }
        FeatureFlag featureFlag = this.projectConfig.getFeatureKeyMapping().get(featureKey);
        if (featureFlag == null) {
            logger.info("No feature flag was found for key \"{}\".", (Object)featureKey);
            return null;
        }
        FeatureVariable variable = featureFlag.getVariableKeyToFeatureVariableMap().get(variableKey);
        if (variable == null) {
            logger.info("No feature variable was found for key \"{}\" in feature flag \"{}\".", (Object)variableKey, (Object)featureKey);
            return null;
        }
        if (!variable.getType().equals((Object)variableType)) {
            logger.info("The feature variable \"" + variableKey + "\" is actually of type \"" + variable.getType().toString() + "\" type. You tried to access it as type \"" + variableType.toString() + "\". Please use the appropriate feature variable accessor.");
            return null;
        }
        String variableValue = variable.getDefaultValue();
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        FeatureDecision featureDecision = this.decisionService.getVariationForFeature(featureFlag, userId, copiedAttributes);
        if (featureDecision.variation != null) {
            FeatureVariableUsageInstance featureVariableUsageInstance = featureDecision.variation.getVariableIdToFeatureVariableUsageInstanceMap().get(variable.getId());
            variableValue = featureVariableUsageInstance != null ? featureVariableUsageInstance.getValue() : variable.getDefaultValue();
        } else {
            logger.info("User \"{}\" was not bucketed into any variation for feature flag \"{}\". The default value \"{}\" for \"{}\" is being returned.", new Object[]{userId, featureKey, variableValue, variableKey});
        }
        return variableValue;
    }

    public List<String> getEnabledFeatures(@Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        ArrayList<String> enabledFeaturesList = new ArrayList<String>();
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getEnabledFeatures call.");
            return enabledFeaturesList;
        }
        if (!this.validateUserId(userId)) {
            return enabledFeaturesList;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        for (FeatureFlag featureFlag : this.projectConfig.getFeatureFlags()) {
            String featureKey = featureFlag.getKey();
            if (!this.isFeatureEnabled(featureKey, userId, copiedAttributes).booleanValue()) continue;
            enabledFeaturesList.add(featureKey);
        }
        return enabledFeaturesList;
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experiment, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownExperimentException {
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        return this.decisionService.getVariation(experiment, userId, copiedAttributes);
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experimentKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getVariation call.");
            return null;
        }
        if (!this.validateUserId(userId)) {
            return null;
        }
        if (experimentKey == null || experimentKey.trim().isEmpty()) {
            logger.error("The experimentKey parameter must be nonnull.");
            return null;
        }
        ProjectConfig currentConfig = this.getProjectConfig();
        Experiment experiment = currentConfig.getExperimentForKey(experimentKey, this.errorHandler);
        if (experiment == null) {
            return null;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        return this.decisionService.getVariation(experiment, userId, copiedAttributes);
    }

    public boolean setForcedVariation(@Nonnull String experimentKey, @Nonnull String userId, @Nullable String variationKey) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing setForcedVariation call.");
            return false;
        }
        return this.projectConfig.setForcedVariation(experimentKey, userId, variationKey);
    }

    @Nullable
    public Variation getForcedVariation(@Nonnull String experimentKey, @Nonnull String userId) {
        if (!this.isValid) {
            logger.error("Optimizely instance is not valid, failing getForcedVariation call.");
            return null;
        }
        return this.projectConfig.getForcedVariation(experimentKey, userId);
    }

    @Nonnull
    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @Nullable
    public UserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    private boolean validateUserId(String userId) {
        if (userId == null) {
            logger.error("The user ID parameter must be nonnull.");
            return false;
        }
        return true;
    }

    private Map<String, ?> copyAttributes(Map<String, ?> attributes) {
        HashMap copiedAttributes = null;
        if (attributes != null) {
            copiedAttributes = new HashMap(attributes);
        }
        return copiedAttributes;
    }

    public static Builder builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
        return new Builder(datafile, eventHandler);
    }

    public static class Builder {
        private String datafile;
        private Bucketer bucketer;
        private DecisionService decisionService;
        private ErrorHandler errorHandler;
        private EventHandler eventHandler;
        private EventFactory eventFactory;
        private EventBatch.ClientEngine clientEngine;
        private String clientVersion;
        private ProjectConfig projectConfig;
        private UserProfileService userProfileService;

        public Builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
            this.datafile = datafile;
            this.eventHandler = eventHandler;
        }

        protected Builder withBucketing(Bucketer bucketer) {
            this.bucketer = bucketer;
            return this;
        }

        protected Builder withDecisionService(DecisionService decisionService) {
            this.decisionService = decisionService;
            return this;
        }

        public Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withUserProfileService(UserProfileService userProfileService) {
            this.userProfileService = userProfileService;
            return this;
        }

        public Builder withClientEngine(EventBatch.ClientEngine clientEngine) {
            this.clientEngine = clientEngine;
            return this;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        protected Builder withEventBuilder(EventFactory eventFactory) {
            this.eventFactory = eventFactory;
            return this;
        }

        protected Builder withConfig(ProjectConfig projectConfig) {
            this.projectConfig = projectConfig;
            return this;
        }

        public Optimizely build() {
            if (this.clientEngine == null) {
                this.clientEngine = EventBatch.ClientEngine.JAVA_SDK;
            }
            if (this.clientVersion == null) {
                this.clientVersion = BuildVersionInfo.VERSION;
            }
            if (this.eventFactory == null) {
                this.eventFactory = new EventFactory(this.clientEngine, this.clientVersion);
            }
            if (this.errorHandler == null) {
                this.errorHandler = new NoOpErrorHandler();
            }
            if (this.bucketer != null && this.decisionService == null) {
                this.decisionService = new DecisionService(this.bucketer, this.errorHandler, this.projectConfig, this.userProfileService);
            }
            Optimizely optimizely = new Optimizely(this.eventHandler, this.eventFactory, this.errorHandler, this.decisionService, this.userProfileService);
            optimizely.initialize(this.datafile, this.projectConfig);
            return optimizely;
        }
    }
}

