/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.notification;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.notification.NotificationListener;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(NotificationBroadcaster.class);
    @VisibleForTesting
    final HashSet<NotificationListener> listeners = new HashSet();

    public void addListener(@Nonnull NotificationListener listener) {
        if (this.listeners.contains(listener)) {
            logger.debug("Notification listener was not added because it already existed");
            return;
        }
        this.listeners.add(listener);
        logger.debug("Notification listener was added");
    }

    public void removeListener(@Nonnull NotificationListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            logger.debug("Notification listener was removed");
            return;
        }
        logger.debug("Notification listener was not removed because it did not exist");
    }

    public void clearListeners() {
        this.listeners.clear();
        logger.debug("Notification listeners were cleared");
    }

    public void broadcastEventTracked(@Nonnull String eventKey, @Nonnull String userId, @Nonnull Map<String, String> attributes, @CheckForNull Long eventValue, @Nonnull LogEvent logEvent) {
        for (NotificationListener iterListener : this.listeners) {
            iterListener.onEventTracked(eventKey, userId, attributes, eventValue, logEvent);
        }
    }

    public void broadcastExperimentActivated(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, String> attributes, @Nonnull Variation variation) {
        for (NotificationListener iterListener : this.listeners) {
            iterListener.onExperimentActivated(experiment, userId, attributes, variation);
        }
    }
}

