/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.internal;

import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Condition;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExperimentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentUtils.class);

    private ExperimentUtils() {
    }

    public static boolean isExperimentActive(@Nonnull Experiment experiment) {
        if (!experiment.isActive()) {
            logger.info("Experiment \"{}\" is not running.", (Object)experiment.getKey());
            return false;
        }
        return true;
    }

    public static boolean isUserInExperiment(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull Map<String, String> attributes) {
        List<String> experimentAudienceIds = experiment.getAudienceIds();
        if (experimentAudienceIds.isEmpty()) {
            return true;
        }
        if (attributes.isEmpty()) {
            return false;
        }
        for (String audienceId : experimentAudienceIds) {
            Condition conditions = projectConfig.getAudienceConditionsFromId(audienceId);
            if (!conditions.evaluate(attributes)) continue;
            return true;
        }
        return false;
    }
}

