/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.internal;

import com.optimizely.ab.internal.ReservedEventKey;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventTagUtils {
    private static final Logger logger = LoggerFactory.getLogger(EventTagUtils.class);

    public static Long getRevenueValue(@Nonnull Map<String, ?> eventTags) {
        Long eventValue = null;
        if (eventTags.containsKey(ReservedEventKey.REVENUE.toString())) {
            Object rawValue = eventTags.get(ReservedEventKey.REVENUE.toString());
            if (Long.class.isInstance(rawValue)) {
                eventValue = (Long)rawValue;
                logger.info("Parsed revenue value \"{}\" from event tags.", (Object)eventValue);
            } else if (Integer.class.isInstance(rawValue)) {
                eventValue = ((Integer)rawValue).longValue();
                logger.info("Parsed revenue value \"{}\" from event tags.", (Object)eventValue);
            } else {
                logger.warn("Failed to parse revenue value \"{}\" from event tags.", rawValue);
            }
        }
        return eventValue;
    }
}

