/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.serializer;

import com.optimizely.ab.event.internal.payload.Conversion;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.event.internal.payload.EventMetric;
import com.optimizely.ab.event.internal.payload.Feature;
import com.optimizely.ab.event.internal.payload.Impression;
import com.optimizely.ab.event.internal.payload.LayerState;
import com.optimizely.ab.event.internal.serializer.Serializer;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class JsonSimpleSerializer
implements Serializer {
    JsonSimpleSerializer() {
    }

    @Override
    public <T extends Event> String serialize(T payload) {
        JSONObject payloadJsonObj = payload instanceof Impression ? this.serializeImpression((Impression)payload) : this.serializeConversion((Conversion)payload);
        return payloadJsonObj.toJSONString();
    }

    private JSONObject serializeImpression(Impression impression) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"visitorId", (Object)impression.getVisitorId());
        jsonObject.put((Object)"timestamp", (Object)impression.getTimestamp());
        jsonObject.put((Object)"isGlobalHoldback", (Object)impression.getIsGlobalHoldback());
        jsonObject.put((Object)"anonymizeIP", (Object)impression.getAnonymizeIP());
        jsonObject.put((Object)"projectId", (Object)impression.getProjectId());
        jsonObject.put((Object)"decision", (Object)this.serializeDecision(impression.getDecision()));
        jsonObject.put((Object)"layerId", (Object)impression.getLayerId());
        jsonObject.put((Object)"accountId", (Object)impression.getAccountId());
        jsonObject.put((Object)"userFeatures", (Object)this.serializeFeatures(impression.getUserFeatures()));
        jsonObject.put((Object)"clientEngine", (Object)impression.getClientEngine());
        jsonObject.put((Object)"clientVersion", (Object)impression.getClientVersion());
        jsonObject.put((Object)"revision", (Object)impression.getRevision());
        if (impression.getSessionId() != null) {
            jsonObject.put((Object)"sessionId", (Object)impression.getSessionId());
        }
        return jsonObject;
    }

    private JSONObject serializeConversion(Conversion conversion) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"visitorId", (Object)conversion.getVisitorId());
        jsonObject.put((Object)"timestamp", (Object)conversion.getTimestamp());
        jsonObject.put((Object)"projectId", (Object)conversion.getProjectId());
        jsonObject.put((Object)"accountId", (Object)conversion.getAccountId());
        jsonObject.put((Object)"userFeatures", (Object)this.serializeFeatures(conversion.getUserFeatures()));
        jsonObject.put((Object)"layerStates", (Object)this.serializeLayerStates(conversion.getLayerStates()));
        jsonObject.put((Object)"eventEntityId", (Object)conversion.getEventEntityId());
        jsonObject.put((Object)"eventName", (Object)conversion.getEventName());
        jsonObject.put((Object)"eventMetrics", (Object)this.serializeEventMetrics(conversion.getEventMetrics()));
        jsonObject.put((Object)"eventFeatures", (Object)this.serializeFeatures(conversion.getEventFeatures()));
        jsonObject.put((Object)"isGlobalHoldback", (Object)conversion.getIsGlobalHoldback());
        jsonObject.put((Object)"anonymizeIP", (Object)conversion.getAnonymizeIP());
        jsonObject.put((Object)"clientEngine", (Object)conversion.getClientEngine());
        jsonObject.put((Object)"clientVersion", (Object)conversion.getClientVersion());
        jsonObject.put((Object)"revision", (Object)conversion.getRevision());
        if (conversion.getSessionId() != null) {
            jsonObject.put((Object)"sessionId", (Object)conversion.getSessionId());
        }
        return jsonObject;
    }

    private JSONObject serializeDecision(Decision decision) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"variationId", (Object)decision.getVariationId());
        jsonObject.put((Object)"isLayerHoldback", (Object)decision.getIsLayerHoldback());
        jsonObject.put((Object)"experimentId", (Object)decision.getExperimentId());
        return jsonObject;
    }

    private JSONArray serializeFeatures(List<Feature> features) {
        JSONArray jsonArray = new JSONArray();
        for (Feature feature : features) {
            jsonArray.add((Object)this.serializeFeature(feature));
        }
        return jsonArray;
    }

    private JSONObject serializeFeature(Feature feature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)feature.getId());
        jsonObject.put((Object)"name", (Object)feature.getName());
        jsonObject.put((Object)"type", (Object)feature.getType());
        jsonObject.put((Object)"value", feature.getValue());
        jsonObject.put((Object)"shouldIndex", (Object)feature.getShouldIndex());
        return jsonObject;
    }

    private JSONArray serializeLayerStates(List<LayerState> layerStates) {
        JSONArray jsonArray = new JSONArray();
        for (LayerState layerState : layerStates) {
            jsonArray.add((Object)this.serializeLayerState(layerState));
        }
        return jsonArray;
    }

    private JSONObject serializeLayerState(LayerState layerState) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"layerId", (Object)layerState.getLayerId());
        jsonObject.put((Object)"revision", (Object)layerState.getRevision());
        jsonObject.put((Object)"decision", (Object)this.serializeDecision(layerState.getDecision()));
        jsonObject.put((Object)"actionTriggered", (Object)layerState.getActionTriggered());
        return jsonObject;
    }

    private JSONArray serializeEventMetrics(List<EventMetric> eventMetrics) {
        JSONArray jsonArray = new JSONArray();
        for (EventMetric eventMetric : eventMetrics) {
            jsonArray.add((Object)this.serializeEventMetric(eventMetric));
        }
        return jsonArray;
    }

    private JSONObject serializeEventMetric(EventMetric eventMetric) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)eventMetric.getName());
        jsonObject.put((Object)"value", (Object)eventMetric.getValue());
        return jsonObject;
    }
}

