/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.EventBuilder;
import com.optimizely.ab.event.internal.payload.Conversion;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.event.internal.payload.EventMetric;
import com.optimizely.ab.event.internal.payload.Feature;
import com.optimizely.ab.event.internal.payload.Impression;
import com.optimizely.ab.event.internal.payload.LayerState;
import com.optimizely.ab.event.internal.serializer.DefaultJsonSerializer;
import com.optimizely.ab.event.internal.serializer.Serializer;
import com.optimizely.ab.internal.EventTagUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuilderV2
extends EventBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EventBuilderV2.class);
    static final String IMPRESSION_ENDPOINT = "https://logx.optimizely.com/log/decision";
    static final String CONVERSION_ENDPOINT = "https://logx.optimizely.com/log/event";
    @VisibleForTesting
    public final Event.ClientEngine clientEngine;
    @VisibleForTesting
    public final String clientVersion;
    private Serializer serializer;

    public EventBuilderV2() {
        this(Event.ClientEngine.JAVA_SDK, BuildVersionInfo.VERSION);
    }

    public EventBuilderV2(Event.ClientEngine clientEngine, String clientVersion) {
        this.clientEngine = clientEngine;
        this.clientVersion = clientVersion;
        this.serializer = DefaultJsonSerializer.getInstance();
    }

    @Override
    public LogEvent createImpressionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment activatedExperiment, @Nonnull Variation variation, @Nonnull String userId, @Nonnull Map<String, String> attributes) {
        Impression impressionPayload = new Impression();
        impressionPayload.setVisitorId(userId);
        impressionPayload.setTimestamp(System.currentTimeMillis());
        impressionPayload.setIsGlobalHoldback(false);
        impressionPayload.setProjectId(projectConfig.getProjectId());
        Decision decision = new Decision();
        decision.setVariationId(variation.getId());
        decision.setIsLayerHoldback(false);
        decision.setExperimentId(activatedExperiment.getId());
        impressionPayload.setDecision(decision);
        impressionPayload.setLayerId(activatedExperiment.getLayerId());
        impressionPayload.setAccountId(projectConfig.getAccountId());
        impressionPayload.setUserFeatures(this.createUserFeatures(attributes, projectConfig));
        impressionPayload.setClientEngine(this.clientEngine);
        impressionPayload.setClientVersion(this.clientVersion);
        impressionPayload.setAnonymizeIP(projectConfig.getAnonymizeIP());
        impressionPayload.setRevision(projectConfig.getRevision());
        String payload = this.serializer.serialize(impressionPayload);
        return new LogEvent(LogEvent.RequestMethod.POST, IMPRESSION_ENDPOINT, Collections.<String, String>emptyMap(), payload);
    }

    @Override
    public LogEvent createConversionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull Map<Experiment, Variation> experimentVariationMap, @Nonnull String userId, @Nonnull String eventId, @Nonnull String eventName, @Nonnull Map<String, String> attributes, @Nonnull Map<String, ?> eventTags) {
        if (experimentVariationMap.isEmpty()) {
            return null;
        }
        List<LayerState> layerStates = this.createLayerStates(projectConfig, experimentVariationMap);
        Long eventValue = EventTagUtils.getRevenueValue(eventTags);
        List<EventMetric> eventMetrics = Collections.emptyList();
        if (eventValue != null) {
            eventMetrics = Collections.singletonList(new EventMetric("revenue", eventValue));
        }
        Conversion conversionPayload = new Conversion();
        conversionPayload.setAccountId(projectConfig.getAccountId());
        conversionPayload.setAnonymizeIP(projectConfig.getAnonymizeIP());
        conversionPayload.setClientEngine(this.clientEngine);
        conversionPayload.setClientVersion(this.clientVersion);
        conversionPayload.setEventEntityId(eventId);
        conversionPayload.setEventFeatures(this.createEventFeatures(eventTags));
        conversionPayload.setEventName(eventName);
        conversionPayload.setEventMetrics(eventMetrics);
        conversionPayload.setIsGlobalHoldback(false);
        conversionPayload.setLayerStates(layerStates);
        conversionPayload.setProjectId(projectConfig.getProjectId());
        conversionPayload.setRevision(projectConfig.getRevision());
        conversionPayload.setTimestamp(System.currentTimeMillis());
        conversionPayload.setUserFeatures(this.createUserFeatures(attributes, projectConfig));
        conversionPayload.setVisitorId(userId);
        String payload = this.serializer.serialize(conversionPayload);
        return new LogEvent(LogEvent.RequestMethod.POST, CONVERSION_ENDPOINT, Collections.<String, String>emptyMap(), payload);
    }

    private List<Feature> createUserFeatures(Map<String, String> attributes, ProjectConfig projectConfig) {
        Map<String, Attribute> attributeKeyMapping = projectConfig.getAttributeKeyMapping();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
            String attributeKey = attributeEntry.getKey();
            Attribute attribute = attributeKeyMapping.get(attributeKey);
            if (attribute == null) {
                logger.warn("Attempting to use unknown attribute key: {}. Attribute will be ignored", (Object)attributeKey);
                continue;
            }
            features.add(new Feature(attribute.getId(), attributeKey, "custom", attributeEntry.getValue(), true));
        }
        return features;
    }

    private List<Feature> createEventFeatures(Map<String, ?> eventTags) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map.Entry<String, ?> eventTagEntry : eventTags.entrySet()) {
            String eventTagKey = eventTagEntry.getKey();
            features.add(new Feature("", eventTagKey, "custom", eventTagEntry.getValue(), false));
        }
        return features;
    }

    private List<LayerState> createLayerStates(ProjectConfig projectConfig, Map<Experiment, Variation> experimentVariationMap) {
        ArrayList<LayerState> layerStates = new ArrayList<LayerState>();
        for (Map.Entry<Experiment, Variation> entry : experimentVariationMap.entrySet()) {
            Experiment experiment = entry.getKey();
            Variation variation = entry.getValue();
            Decision decision = new Decision(variation.getId(), false, experiment.getId());
            layerStates.add(new LayerState(experiment.getLayerId(), projectConfig.getRevision(), decision, true));
        }
        return layerStates;
    }
}

