/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.parser.AudienceJacksonDeserializer;
import com.optimizely.ab.config.parser.GroupJacksonDeserializer;
import java.io.IOException;
import java.util.List;

class ProjectConfigJacksonDeserializer
extends JsonDeserializer<ProjectConfig> {
    ProjectConfigJacksonDeserializer() {
    }

    public ProjectConfig deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Audience.class, (JsonDeserializer)new AudienceJacksonDeserializer());
        module.addDeserializer(Group.class, (JsonDeserializer)new GroupJacksonDeserializer());
        mapper.registerModule((Module)module);
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String accountId = node.get("accountId").textValue();
        String projectId = node.get("projectId").textValue();
        String revision = node.get("revision").textValue();
        String version = node.get("version").textValue();
        List groups = (List)mapper.readValue(node.get("groups").toString(), (TypeReference)new TypeReference<List<Group>>(){});
        List experiments = (List)mapper.readValue(node.get("experiments").toString(), (TypeReference)new TypeReference<List<Experiment>>(){});
        List attributes = version.equals(ProjectConfig.Version.V1.toString()) ? (List)mapper.readValue(node.get("dimensions").toString(), (TypeReference)new TypeReference<List<Attribute>>(){}) : (List)mapper.readValue(node.get("attributes").toString(), (TypeReference)new TypeReference<List<Attribute>>(){});
        List events = (List)mapper.readValue(node.get("events").toString(), (TypeReference)new TypeReference<List<EventType>>(){});
        List audiences = (List)mapper.readValue(node.get("audiences").toString(), (TypeReference)new TypeReference<List<Audience>>(){});
        boolean anonymizeIP = false;
        List liveVariables = null;
        if (version.equals(ProjectConfig.Version.V3.toString())) {
            liveVariables = (List)mapper.readValue(node.get("variables").toString(), (TypeReference)new TypeReference<List<LiveVariable>>(){});
            anonymizeIP = node.get("anonymizeIP").asBoolean();
        }
        return new ProjectConfig(accountId, projectId, version, revision, groups, experiments, attributes, events, audiences, anonymizeIP, liveVariables);
    }
}

