/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import java.lang.reflect.Type;
import java.util.List;

public class ProjectConfigGsonDeserializer
implements JsonDeserializer<ProjectConfig> {
    public ProjectConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String accountId = jsonObject.get("accountId").getAsString();
        String projectId = jsonObject.get("projectId").getAsString();
        String revision = jsonObject.get("revision").getAsString();
        String version = jsonObject.get("version").getAsString();
        Type groupsType = new TypeToken<List<Group>>(){}.getType();
        Type experimentsType = new TypeToken<List<Experiment>>(){}.getType();
        Type attributesType = new TypeToken<List<Attribute>>(){}.getType();
        Type eventsType = new TypeToken<List<EventType>>(){}.getType();
        Type audienceType = new TypeToken<List<Audience>>(){}.getType();
        List groups = (List)context.deserialize((JsonElement)jsonObject.get("groups").getAsJsonArray(), groupsType);
        List experiments = (List)context.deserialize((JsonElement)jsonObject.get("experiments").getAsJsonArray(), experimentsType);
        List attributes = version.equals(ProjectConfig.Version.V1.toString()) ? (List)context.deserialize(jsonObject.get("dimensions"), attributesType) : (List)context.deserialize(jsonObject.get("attributes"), attributesType);
        List events = (List)context.deserialize((JsonElement)jsonObject.get("events").getAsJsonArray(), eventsType);
        List audiences = (List)context.deserialize((JsonElement)jsonObject.get("audiences").getAsJsonArray(), audienceType);
        boolean anonymizeIP = false;
        List liveVariables = null;
        if (version.equals(ProjectConfig.Version.V3.toString())) {
            Type liveVariablesType = new TypeToken<List<LiveVariable>>(){}.getType();
            liveVariables = (List)context.deserialize((JsonElement)jsonObject.getAsJsonArray("variables"), liveVariablesType);
            anonymizeIP = jsonObject.get("anonymizeIP").getAsBoolean();
        }
        return new ProjectConfig(accountId, projectId, version, revision, groups, experiments, attributes, events, audiences, anonymizeIP, liveVariables);
    }
}

