/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

final class JsonSimpleConfigParser
implements ConfigParser {
    JsonSimpleConfigParser() {
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        try {
            JSONParser parser = new JSONParser();
            JSONObject rootObject = (JSONObject)parser.parse(json);
            String accountId = (String)rootObject.get((Object)"accountId");
            String projectId = (String)rootObject.get((Object)"projectId");
            String revision = (String)rootObject.get((Object)"revision");
            String version = (String)rootObject.get((Object)"version");
            List<Experiment> experiments = this.parseExperiments((JSONArray)rootObject.get((Object)"experiments"));
            if (version.equals(ProjectConfig.Version.V1.toString())) {
                throw new ConfigParseException("The Java SDK no longer supports datafile version 1. If you wish to use a Classic Custom Project, please use Java SDK version 1.6 or below.");
            }
            List<Attribute> attributes = this.parseAttributes((JSONArray)rootObject.get((Object)"attributes"));
            List<EventType> events = this.parseEvents((JSONArray)rootObject.get((Object)"events"));
            List<Audience> audiences = this.parseAudiences((JSONArray)parser.parse(rootObject.get((Object)"audiences").toString()));
            List<Group> groups = this.parseGroups((JSONArray)rootObject.get((Object)"groups"));
            boolean anonymizeIP = false;
            List<LiveVariable> liveVariables = null;
            if (version.equals(ProjectConfig.Version.V3.toString())) {
                liveVariables = this.parseLiveVariables((JSONArray)rootObject.get((Object)"variables"));
                anonymizeIP = (Boolean)rootObject.get((Object)"anonymizeIP");
            }
            return new ProjectConfig(accountId, projectId, version, revision, groups, experiments, attributes, events, audiences, anonymizeIP, liveVariables);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson) {
        return this.parseExperiments(experimentJson, "");
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson, String groupId) {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>(experimentJson.size());
        for (Object obj : experimentJson) {
            JSONObject experimentObject = (JSONObject)obj;
            String id = (String)experimentObject.get((Object)"id");
            String key = (String)experimentObject.get((Object)"key");
            Object statusJson = experimentObject.get((Object)"status");
            String status = statusJson == null ? Experiment.ExperimentStatus.NOT_STARTED.toString() : (String)experimentObject.get((Object)"status");
            Object layerIdObject = experimentObject.get((Object)"layerId");
            String layerId = layerIdObject == null ? null : (String)layerIdObject;
            JSONArray audienceIdsJson = (JSONArray)experimentObject.get((Object)"audienceIds");
            ArrayList<String> audienceIds = new ArrayList<String>(audienceIdsJson.size());
            for (Object audienceIdObj : audienceIdsJson) {
                audienceIds.add((String)audienceIdObj);
            }
            List<Variation> variations = this.parseVariations((JSONArray)experimentObject.get((Object)"variations"));
            Map<String, String> userIdToVariationKeyMap = this.parseForcedVariations((JSONObject)experimentObject.get((Object)"forcedVariations"));
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation((JSONArray)experimentObject.get((Object)"trafficAllocation"));
            experiments.add(new Experiment(id, key, status, layerId, audienceIds, variations, userIdToVariationKeyMap, trafficAllocations, groupId));
        }
        return experiments;
    }

    private List<Variation> parseVariations(JSONArray variationJson) {
        ArrayList<Variation> variations = new ArrayList<Variation>(variationJson.size());
        for (Object obj : variationJson) {
            JSONObject variationObject = (JSONObject)obj;
            String id = (String)variationObject.get((Object)"id");
            String key = (String)variationObject.get((Object)"key");
            List<LiveVariableUsageInstance> liveVariableUsageInstances = null;
            if (variationObject.containsKey((Object)"variables")) {
                liveVariableUsageInstances = this.parseLiveVariableInstances((JSONArray)variationObject.get((Object)"variables"));
            }
            variations.add(new Variation(id, key, liveVariableUsageInstances));
        }
        return variations;
    }

    private Map<String, String> parseForcedVariations(JSONObject forcedVariationJson) {
        HashMap<String, String> userIdToVariationKeyMap = new HashMap<String, String>();
        for (Object obj : forcedVariationJson.entrySet()) {
            Map.Entry entry = (Map.Entry)obj;
            userIdToVariationKeyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return userIdToVariationKeyMap;
    }

    private List<TrafficAllocation> parseTrafficAllocation(JSONArray trafficAllocationJson) {
        ArrayList<TrafficAllocation> trafficAllocation = new ArrayList<TrafficAllocation>(trafficAllocationJson.size());
        for (Object obj : trafficAllocationJson) {
            JSONObject allocationObject = (JSONObject)obj;
            String entityId = (String)allocationObject.get((Object)"entityId");
            long endOfRange = (Long)allocationObject.get((Object)"endOfRange");
            trafficAllocation.add(new TrafficAllocation(entityId, (int)endOfRange));
        }
        return trafficAllocation;
    }

    private List<Attribute> parseAttributes(JSONArray attributeJson) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributeJson.size());
        for (Object obj : attributeJson) {
            JSONObject attributeObject = (JSONObject)obj;
            String id = (String)attributeObject.get((Object)"id");
            String key = (String)attributeObject.get((Object)"key");
            String segmentId = (String)attributeObject.get((Object)"segmentId");
            attributes.add(new Attribute(id, key, segmentId));
        }
        return attributes;
    }

    private List<EventType> parseEvents(JSONArray eventJson) {
        ArrayList<EventType> events = new ArrayList<EventType>(eventJson.size());
        for (Object obj : eventJson) {
            JSONObject eventObject = (JSONObject)obj;
            JSONArray experimentIdsJson = (JSONArray)eventObject.get((Object)"experimentIds");
            ArrayList<String> experimentIds = new ArrayList<String>(experimentIdsJson.size());
            for (Object experimentIdObj : experimentIdsJson) {
                experimentIds.add((String)experimentIdObj);
            }
            String id = (String)eventObject.get((Object)"id");
            String key = (String)eventObject.get((Object)"key");
            events.add(new EventType(id, key, experimentIds));
        }
        return events;
    }

    private List<Audience> parseAudiences(JSONArray audienceJson) throws ParseException {
        JSONParser parser = new JSONParser();
        ArrayList<Audience> audiences = new ArrayList<Audience>(audienceJson.size());
        for (Object obj : audienceJson) {
            JSONObject audienceObject = (JSONObject)obj;
            String id = (String)audienceObject.get((Object)"id");
            String key = (String)audienceObject.get((Object)"name");
            String conditionString = (String)audienceObject.get((Object)"conditions");
            JSONArray conditionJson = (JSONArray)parser.parse(conditionString);
            Condition conditions = this.parseConditions(conditionJson);
            audiences.add(new Audience(id, key, conditions));
        }
        return audiences;
    }

    private Condition parseConditions(JSONArray conditionJson) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String operand = (String)conditionJson.get(0);
        for (int i = 1; i < conditionJson.size(); ++i) {
            Object obj = conditionJson.get(i);
            if (obj instanceof JSONArray) {
                conditions.add(this.parseConditions((JSONArray)conditionJson.get(i)));
                continue;
            }
            JSONObject conditionMap = (JSONObject)obj;
            conditions.add(new UserAttribute((String)conditionMap.get((Object)"name"), (String)conditionMap.get((Object)"type"), (String)conditionMap.get((Object)"value")));
        }
        Condition condition = operand.equals("and") ? new AndCondition(conditions) : (operand.equals("or") ? new OrCondition(conditions) : new NotCondition((Condition)conditions.get(0)));
        return condition;
    }

    private List<Group> parseGroups(JSONArray groupJson) {
        ArrayList<Group> groups = new ArrayList<Group>(groupJson.size());
        for (Object obj : groupJson) {
            JSONObject groupObject = (JSONObject)obj;
            String id = (String)groupObject.get((Object)"id");
            String policy = (String)groupObject.get((Object)"policy");
            List<Experiment> experiments = this.parseExperiments((JSONArray)groupObject.get((Object)"experiments"), id);
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation((JSONArray)groupObject.get((Object)"trafficAllocation"));
            groups.add(new Group(id, policy, experiments, trafficAllocations));
        }
        return groups;
    }

    private List<LiveVariable> parseLiveVariables(JSONArray liveVariablesJson) {
        ArrayList<LiveVariable> liveVariables = new ArrayList<LiveVariable>(liveVariablesJson.size());
        for (Object obj : liveVariablesJson) {
            JSONObject liveVariableObject = (JSONObject)obj;
            String id = (String)liveVariableObject.get((Object)"id");
            String key = (String)liveVariableObject.get((Object)"key");
            String defaultValue = (String)liveVariableObject.get((Object)"defaultValue");
            LiveVariable.VariableType type = LiveVariable.VariableType.fromString((String)liveVariableObject.get((Object)"type"));
            LiveVariable.VariableStatus status = LiveVariable.VariableStatus.fromString((String)liveVariableObject.get((Object)"status"));
            liveVariables.add(new LiveVariable(id, key, defaultValue, status, type));
        }
        return liveVariables;
    }

    private List<LiveVariableUsageInstance> parseLiveVariableInstances(JSONArray liveVariableInstancesJson) {
        ArrayList<LiveVariableUsageInstance> liveVariableUsageInstances = new ArrayList<LiveVariableUsageInstance>(liveVariableInstancesJson.size());
        for (Object obj : liveVariableInstancesJson) {
            JSONObject liveVariableInstanceObject = (JSONObject)obj;
            String id = (String)liveVariableInstanceObject.get((Object)"id");
            String value = (String)liveVariableInstanceObject.get((Object)"value");
            liveVariableUsageInstances.add(new LiveVariableUsageInstance(id, value));
        }
        return liveVariableUsageInstances;
    }
}

