/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONObject;

final class JsonConfigParser
implements ConfigParser {
    JsonConfigParser() {
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        try {
            JSONObject rootObject = new JSONObject(json);
            String accountId = rootObject.getString("accountId");
            String projectId = rootObject.getString("projectId");
            String revision = rootObject.getString("revision");
            String version = rootObject.getString("version");
            List<Experiment> experiments = this.parseExperiments(rootObject.getJSONArray("experiments"));
            List<Attribute> attributes = version.equals(ProjectConfig.Version.V1.toString()) ? this.parseAttributes(rootObject.getJSONArray("dimensions")) : this.parseAttributes(rootObject.getJSONArray("attributes"));
            List<EventType> events = this.parseEvents(rootObject.getJSONArray("events"));
            List<Audience> audiences = this.parseAudiences(rootObject.getJSONArray("audiences"));
            List<Group> groups = this.parseGroups(rootObject.getJSONArray("groups"));
            boolean anonymizeIP = false;
            List<LiveVariable> liveVariables = null;
            if (version.equals(ProjectConfig.Version.V3.toString())) {
                liveVariables = this.parseLiveVariables(rootObject.getJSONArray("variables"));
                anonymizeIP = rootObject.getBoolean("anonymizeIP");
            }
            return new ProjectConfig(accountId, projectId, version, revision, groups, experiments, attributes, events, audiences, anonymizeIP, liveVariables);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson) {
        return this.parseExperiments(experimentJson, "");
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson, String groupId) {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>(experimentJson.length());
        for (Object obj : experimentJson) {
            JSONObject experimentObject = (JSONObject)obj;
            String id = experimentObject.getString("id");
            String key = experimentObject.getString("key");
            String status = experimentObject.isNull("status") ? Experiment.ExperimentStatus.NOT_STARTED.toString() : experimentObject.getString("status");
            String layerId = experimentObject.has("layerId") ? experimentObject.getString("layerId") : null;
            JSONArray audienceIdsJson = experimentObject.getJSONArray("audienceIds");
            ArrayList<String> audienceIds = new ArrayList<String>(audienceIdsJson.length());
            for (Object audienceIdObj : audienceIdsJson) {
                audienceIds.add((String)audienceIdObj);
            }
            List<Variation> variations = this.parseVariations(experimentObject.getJSONArray("variations"));
            Map<String, String> userIdToVariationKeyMap = this.parseForcedVariations(experimentObject.getJSONObject("forcedVariations"));
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation(experimentObject.getJSONArray("trafficAllocation"));
            experiments.add(new Experiment(id, key, status, layerId, audienceIds, variations, userIdToVariationKeyMap, trafficAllocations, groupId));
        }
        return experiments;
    }

    private List<Variation> parseVariations(JSONArray variationJson) {
        ArrayList<Variation> variations = new ArrayList<Variation>(variationJson.length());
        for (Object obj : variationJson) {
            JSONObject variationObject = (JSONObject)obj;
            String id = variationObject.getString("id");
            String key = variationObject.getString("key");
            List<LiveVariableUsageInstance> liveVariableUsageInstances = null;
            if (variationObject.has("variables")) {
                liveVariableUsageInstances = this.parseLiveVariableInstances(variationObject.getJSONArray("variables"));
            }
            variations.add(new Variation(id, key, liveVariableUsageInstances));
        }
        return variations;
    }

    private Map<String, String> parseForcedVariations(JSONObject forcedVariationJson) {
        HashMap<String, String> userIdToVariationKeyMap = new HashMap<String, String>();
        Set userIdSet = forcedVariationJson.keySet();
        for (String userId : userIdSet) {
            userIdToVariationKeyMap.put(userId, forcedVariationJson.get(userId).toString());
        }
        return userIdToVariationKeyMap;
    }

    private List<TrafficAllocation> parseTrafficAllocation(JSONArray trafficAllocationJson) {
        ArrayList<TrafficAllocation> trafficAllocation = new ArrayList<TrafficAllocation>(trafficAllocationJson.length());
        for (Object obj : trafficAllocationJson) {
            JSONObject allocationObject = (JSONObject)obj;
            String entityId = allocationObject.getString("entityId");
            int endOfRange = allocationObject.getInt("endOfRange");
            trafficAllocation.add(new TrafficAllocation(entityId, endOfRange));
        }
        return trafficAllocation;
    }

    private List<Attribute> parseAttributes(JSONArray attributeJson) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributeJson.length());
        for (Object obj : attributeJson) {
            JSONObject attributeObject = (JSONObject)obj;
            String id = attributeObject.getString("id");
            String key = attributeObject.getString("key");
            attributes.add(new Attribute(id, key, attributeObject.optString("segmentId", null)));
        }
        return attributes;
    }

    private List<EventType> parseEvents(JSONArray eventJson) {
        ArrayList<EventType> events = new ArrayList<EventType>(eventJson.length());
        for (Object obj : eventJson) {
            JSONObject eventObject = (JSONObject)obj;
            JSONArray experimentIdsJson = eventObject.getJSONArray("experimentIds");
            ArrayList<String> experimentIds = new ArrayList<String>(experimentIdsJson.length());
            for (Object experimentIdObj : experimentIdsJson) {
                experimentIds.add((String)experimentIdObj);
            }
            String id = eventObject.getString("id");
            String key = eventObject.getString("key");
            events.add(new EventType(id, key, experimentIds));
        }
        return events;
    }

    private List<Audience> parseAudiences(JSONArray audienceJson) {
        ArrayList<Audience> audiences = new ArrayList<Audience>(audienceJson.length());
        for (Object obj : audienceJson) {
            JSONObject audienceObject = (JSONObject)obj;
            String id = audienceObject.getString("id");
            String key = audienceObject.getString("name");
            String conditionString = audienceObject.getString("conditions");
            JSONArray conditionJson = new JSONArray(conditionString);
            Condition conditions = this.parseConditions(conditionJson);
            audiences.add(new Audience(id, key, conditions));
        }
        return audiences;
    }

    private Condition parseConditions(JSONArray conditionJson) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String operand = (String)conditionJson.get(0);
        for (int i = 1; i < conditionJson.length(); ++i) {
            Object obj = conditionJson.get(i);
            if (obj instanceof JSONArray) {
                conditions.add(this.parseConditions(conditionJson.getJSONArray(i)));
                continue;
            }
            JSONObject conditionMap = (JSONObject)obj;
            conditions.add(new UserAttribute((String)conditionMap.get("name"), (String)conditionMap.get("type"), (String)conditionMap.get("value")));
        }
        Condition condition = operand.equals("and") ? new AndCondition(conditions) : (operand.equals("or") ? new OrCondition(conditions) : new NotCondition((Condition)conditions.get(0)));
        return condition;
    }

    private List<Group> parseGroups(JSONArray groupJson) {
        ArrayList<Group> groups = new ArrayList<Group>(groupJson.length());
        for (Object obj : groupJson) {
            JSONObject groupObject = (JSONObject)obj;
            String id = groupObject.getString("id");
            String policy = groupObject.getString("policy");
            List<Experiment> experiments = this.parseExperiments(groupObject.getJSONArray("experiments"), id);
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation(groupObject.getJSONArray("trafficAllocation"));
            groups.add(new Group(id, policy, experiments, trafficAllocations));
        }
        return groups;
    }

    private List<LiveVariable> parseLiveVariables(JSONArray liveVariablesJson) {
        ArrayList<LiveVariable> liveVariables = new ArrayList<LiveVariable>(liveVariablesJson.length());
        for (Object obj : liveVariablesJson) {
            JSONObject liveVariableObject = (JSONObject)obj;
            String id = liveVariableObject.getString("id");
            String key = liveVariableObject.getString("key");
            String defaultValue = liveVariableObject.getString("defaultValue");
            LiveVariable.VariableType type = LiveVariable.VariableType.fromString(liveVariableObject.getString("type"));
            LiveVariable.VariableStatus status = LiveVariable.VariableStatus.fromString(liveVariableObject.getString("status"));
            liveVariables.add(new LiveVariable(id, key, defaultValue, status, type));
        }
        return liveVariables;
    }

    private List<LiveVariableUsageInstance> parseLiveVariableInstances(JSONArray liveVariableInstancesJson) {
        ArrayList<LiveVariableUsageInstance> liveVariableUsageInstances = new ArrayList<LiveVariableUsageInstance>(liveVariableInstancesJson.length());
        for (Object obj : liveVariableInstancesJson) {
            JSONObject liveVariableInstanceObject = (JSONObject)obj;
            String id = liveVariableInstanceObject.getString("id");
            String value = liveVariableInstanceObject.getString("value");
            liveVariableUsageInstances.add(new LiveVariableUsageInstance(id, value));
        }
        return liveVariableUsageInstances;
    }
}

