/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class GsonHelpers {
    GsonHelpers() {
    }

    private static List<Variation> parseVariations(JsonArray variationJson, JsonDeserializationContext context) {
        ArrayList<Variation> variations = new ArrayList<Variation>(variationJson.size());
        for (Object obj : variationJson) {
            JsonObject variationObject = (JsonObject)obj;
            String id = variationObject.get("id").getAsString();
            String key = variationObject.get("key").getAsString();
            List variableUsageInstances = null;
            if (variationObject.has("variables")) {
                Type liveVariableUsageInstancesType = new TypeToken<List<LiveVariableUsageInstance>>(){}.getType();
                variableUsageInstances = (List)context.deserialize((JsonElement)variationObject.getAsJsonArray("variables"), liveVariableUsageInstancesType);
            }
            variations.add(new Variation(id, key, variableUsageInstances));
        }
        return variations;
    }

    private static Map<String, String> parseForcedVariations(JsonObject forcedVariationJson) {
        HashMap<String, String> userIdToVariationKeyMap = new HashMap<String, String>();
        Set entrySet = forcedVariationJson.entrySet();
        for (Map.Entry entry : entrySet) {
            userIdToVariationKeyMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return userIdToVariationKeyMap;
    }

    static List<TrafficAllocation> parseTrafficAllocation(JsonArray trafficAllocationJson) {
        ArrayList<TrafficAllocation> trafficAllocation = new ArrayList<TrafficAllocation>(trafficAllocationJson.size());
        for (Object obj : trafficAllocationJson) {
            JsonObject allocationObject = (JsonObject)obj;
            String entityId = allocationObject.get("entityId").getAsString();
            int endOfRange = allocationObject.get("endOfRange").getAsInt();
            trafficAllocation.add(new TrafficAllocation(entityId, endOfRange));
        }
        return trafficAllocation;
    }

    static Experiment parseExperiment(JsonObject experimentJson, String groupId, JsonDeserializationContext context) {
        String id = experimentJson.get("id").getAsString();
        String key = experimentJson.get("key").getAsString();
        JsonElement experimentStatusJson = experimentJson.get("status");
        String status = experimentStatusJson.isJsonNull() ? Experiment.ExperimentStatus.NOT_STARTED.toString() : experimentStatusJson.getAsString();
        JsonElement layerIdJson = experimentJson.get("layerId");
        String layerId = layerIdJson == null ? null : layerIdJson.getAsString();
        JsonArray audienceIdsJson = experimentJson.getAsJsonArray("audienceIds");
        ArrayList<String> audienceIds = new ArrayList<String>(audienceIdsJson.size());
        for (JsonElement audienceIdObj : audienceIdsJson) {
            audienceIds.add(audienceIdObj.getAsString());
        }
        List<Variation> variations = GsonHelpers.parseVariations(experimentJson.getAsJsonArray("variations"), context);
        Map<String, String> userIdToVariationKeyMap = GsonHelpers.parseForcedVariations(experimentJson.getAsJsonObject("forcedVariations"));
        List<TrafficAllocation> trafficAllocations = GsonHelpers.parseTrafficAllocation(experimentJson.getAsJsonArray("trafficAllocation"));
        return new Experiment(id, key, status, layerId, audienceIds, variations, userIdToVariationKeyMap, trafficAllocations, groupId);
    }

    static Experiment parseExperiment(JsonObject experimentJson, JsonDeserializationContext context) {
        return GsonHelpers.parseExperiment(experimentJson, "", context);
    }
}

