/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.parser.AudienceGsonDeserializer;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.ExperimentGsonDeserializer;
import com.optimizely.ab.config.parser.GroupGsonDeserializer;
import com.optimizely.ab.config.parser.ProjectConfigGsonDeserializer;
import javax.annotation.Nonnull;

final class GsonConfigParser
implements ConfigParser {
    GsonConfigParser() {
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        if (json == null) {
            throw new ConfigParseException("Unable to parse null json.");
        }
        if (json.length() == 0) {
            throw new ConfigParseException("Unable to parse empty json.");
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(ProjectConfig.class, (Object)new ProjectConfigGsonDeserializer()).registerTypeAdapter(Audience.class, (Object)new AudienceGsonDeserializer()).registerTypeAdapter(Group.class, (Object)new GroupGsonDeserializer()).registerTypeAdapter(Experiment.class, (Object)new ExperimentGsonDeserializer()).create();
        try {
            return (ProjectConfig)gson.fromJson(json, ProjectConfig.class);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }
}

