/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GroupJacksonDeserializer
extends JsonDeserializer<Group> {
    public Group deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String id = node.get("id").textValue();
        String policy = node.get("policy").textValue();
        List trafficAllocations = (List)mapper.readValue(node.get("trafficAllocation").toString(), (TypeReference)new TypeReference<List<TrafficAllocation>>(){});
        JsonNode groupExperimentsJson = node.get("experiments");
        ArrayList<Experiment> groupExperiments = new ArrayList<Experiment>();
        if (groupExperimentsJson.isArray()) {
            for (JsonNode groupExperimentJson : groupExperimentsJson) {
                groupExperiments.add(this.parseExperiment(groupExperimentJson, id));
            }
        }
        return new Group(id, policy, groupExperiments, trafficAllocations);
    }

    private Experiment parseExperiment(JsonNode experimentJson, String groupId) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String id = experimentJson.get("id").textValue();
        String key = experimentJson.get("key").textValue();
        String status = experimentJson.get("status").textValue();
        JsonNode layerIdJson = experimentJson.get("layerId");
        String layerId = layerIdJson == null ? null : layerIdJson.textValue();
        List audienceIds = (List)mapper.readValue(experimentJson.get("audienceIds").toString(), (TypeReference)new TypeReference<List<String>>(){});
        List variations = (List)mapper.readValue(experimentJson.get("variations").toString(), (TypeReference)new TypeReference<List<Variation>>(){});
        List trafficAllocations = (List)mapper.readValue(experimentJson.get("trafficAllocation").toString(), (TypeReference)new TypeReference<List<TrafficAllocation>>(){});
        Map userIdToVariationKeyMap = (Map)mapper.readValue(experimentJson.get("forcedVariations").toString(), (TypeReference)new TypeReference<Map<String, String>>(){});
        return new Experiment(id, key, status, layerId, audienceIds, variations, userIdToVariationKeyMap, trafficAllocations, groupId);
    }
}

