/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.parser.GsonHelpers;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GroupGsonDeserializer
implements JsonDeserializer<Group> {
    public Group deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String id = jsonObject.get("id").getAsString();
        String policy = jsonObject.get("policy").getAsString();
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        JsonArray experimentsJson = jsonObject.getAsJsonArray("experiments");
        for (Object obj : experimentsJson) {
            JsonObject experimentObj = (JsonObject)obj;
            experiments.add(GsonHelpers.parseExperiment(experimentObj, id, context));
        }
        List<TrafficAllocation> trafficAllocations = GsonHelpers.parseTrafficAllocation(jsonObject.getAsJsonArray("trafficAllocation"));
        return new Group(id, policy, experiments, trafficAllocations);
    }
}

