/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.GsonConfigParser;
import com.optimizely.ab.config.parser.JacksonConfigParser;
import com.optimizely.ab.config.parser.JsonConfigParser;
import com.optimizely.ab.config.parser.JsonSimpleConfigParser;
import com.optimizely.ab.config.parser.MissingJsonParserException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigParser.class);

    private DefaultConfigParser() {
    }

    public static ConfigParser getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Nonnull
    private static ConfigParser create() {
        ConfigParser configParser;
        if (DefaultConfigParser.isPresent("com.fasterxml.jackson.databind.ObjectMapper")) {
            configParser = new JacksonConfigParser();
        } else if (DefaultConfigParser.isPresent("com.google.gson.Gson")) {
            configParser = new GsonConfigParser();
        } else if (DefaultConfigParser.isPresent("org.json.simple.JSONObject")) {
            configParser = new JsonSimpleConfigParser();
        } else if (DefaultConfigParser.isPresent("org.json.JSONObject")) {
            configParser = new JsonConfigParser();
        } else {
            throw new MissingJsonParserException("unable to locate a JSON parser. Please see <link> for more information");
        }
        logger.info("using json parser: {}", (Object)configParser.getClass().getSimpleName());
        return configParser;
    }

    private static boolean isPresent(@Nonnull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static /* synthetic */ ConfigParser access$100() {
        return DefaultConfigParser.create();
    }

    private static class LazyHolder {
        private static final ConfigParser INSTANCE = DefaultConfigParser.access$100();

        private LazyHolder() {
        }
    }
}

