/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AudienceJacksonDeserializer
extends JsonDeserializer<Audience> {
    public Audience deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String id = node.get("id").textValue();
        String name = node.get("name").textValue();
        List rawObjectList = (List)mapper.readValue(node.get("conditions").textValue(), List.class);
        Condition conditions = this.parseConditions(rawObjectList);
        return new Audience(id, name, conditions);
    }

    private Condition parseConditions(List<Object> rawObjectList) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String operand = (String)rawObjectList.get(0);
        for (int i = 1; i < rawObjectList.size(); ++i) {
            Object obj = rawObjectList.get(i);
            if (obj instanceof List) {
                List objectList = (List)rawObjectList.get(i);
                conditions.add(this.parseConditions(objectList));
                continue;
            }
            HashMap conditionMap = (HashMap)rawObjectList.get(i);
            conditions.add(new UserAttribute((String)conditionMap.get("name"), (String)conditionMap.get("type"), (String)conditionMap.get("value")));
        }
        Condition condition = operand.equals("and") ? new AndCondition(conditions) : (operand.equals("or") ? new OrCondition(conditions) : new NotCondition((Condition)conditions.get(0)));
        return condition;
    }
}

