/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.internal.LinkedTreeMap;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class AudienceGsonDeserializer
implements JsonDeserializer<Audience> {
    public Audience deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = json.getAsJsonObject();
        String id = jsonObject.get("id").getAsString();
        String name = jsonObject.get("name").getAsString();
        JsonElement conditionsElement = parser.parse(jsonObject.get("conditions").getAsString());
        List rawObjectList = (List)gson.fromJson(conditionsElement, List.class);
        Condition conditions = this.parseConditions(rawObjectList);
        return new Audience(id, name, conditions);
    }

    private Condition parseConditions(List<Object> rawObjectList) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String operand = (String)rawObjectList.get(0);
        for (int i = 1; i < rawObjectList.size(); ++i) {
            Object obj = rawObjectList.get(i);
            if (obj instanceof List) {
                List objectList = (List)rawObjectList.get(i);
                conditions.add(this.parseConditions(objectList));
                continue;
            }
            LinkedTreeMap conditionMap = (LinkedTreeMap)rawObjectList.get(i);
            conditions.add(new UserAttribute((String)conditionMap.get((Object)"name"), (String)conditionMap.get((Object)"type"), (String)conditionMap.get((Object)"value")));
        }
        Condition condition = operand.equals("and") ? new AndCondition(conditions) : (operand.equals("or") ? new OrCondition(conditions) : new NotCondition((Condition)conditions.get(0)));
        return condition;
    }
}

