/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience;

import com.optimizely.ab.config.audience.Condition;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UserAttribute
implements Condition {
    private final String name;
    private final String type;
    private final String value;

    public UserAttribute(@Nonnull String name, @Nonnull String type, @Nonnull String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean evaluate(Map<String, String> attributes) {
        String userAttributeValue = attributes.get(this.name);
        return this.value.equals(userAttributeValue);
    }

    public String toString() {
        return "{name='" + this.name + "'" + ", type='" + this.type + "'" + ", value='" + this.value + "'" + "}";
    }

    public boolean equals(Object other) {
        if (!(other instanceof UserAttribute)) {
            return false;
        }
        UserAttribute otherConditionObj = (UserAttribute)other;
        return this.name.equals(otherConditionObj.getName()) && this.type.equals(otherConditionObj.getType()) && this.value.equals(otherConditionObj.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

