/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience;

import com.optimizely.ab.config.audience.Condition;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AndCondition
implements Condition {
    private final List<Condition> conditions;

    public AndCondition(@Nonnull List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean evaluate(Map<String, String> attributes) {
        for (Condition condition : this.conditions) {
            if (condition.evaluate(attributes)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[and, ");
        for (int i = 0; i < this.conditions.size(); ++i) {
            s.append(this.conditions.get(i));
            if (i >= this.conditions.size() - 1) continue;
            s.append(", ");
        }
        s.append("]");
        return s.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AndCondition)) {
            return false;
        }
        AndCondition otherAndCondition = (AndCondition)other;
        return this.conditions.equals(otherAndCondition.getConditions());
    }

    public int hashCode() {
        return this.conditions.hashCode();
    }
}

