/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.IdKeyMapped;
import com.optimizely.ab.config.IdMapped;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.Variation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectConfigUtils {
    public static <T extends IdKeyMapped> Map<String, T> generateNameMapping(List<T> nameables) {
        HashMap<String, IdKeyMapped> nameMapping = new HashMap<String, IdKeyMapped>();
        for (IdKeyMapped nameable : nameables) {
            nameMapping.put(nameable.getKey(), nameable);
        }
        return Collections.unmodifiableMap(nameMapping);
    }

    public static <T extends IdMapped> Map<String, T> generateIdMapping(List<T> nameables) {
        HashMap<String, IdMapped> nameMapping = new HashMap<String, IdMapped>();
        for (IdMapped nameable : nameables) {
            nameMapping.put(nameable.getId(), nameable);
        }
        return Collections.unmodifiableMap(nameMapping);
    }

    public static Map<String, List<Experiment>> generateLiveVariableIdToExperimentsMapping(List<Experiment> experiments) {
        HashMap<String, List<Experiment>> variableIdToExperiments = new HashMap<String, List<Experiment>>();
        for (Experiment experiment : experiments) {
            Variation variation;
            if (experiment.getVariations().isEmpty() || (variation = experiment.getVariations().get(0)).getLiveVariableUsageInstances() == null) continue;
            for (LiveVariableUsageInstance usageInstance : variation.getLiveVariableUsageInstances()) {
                ArrayList<Experiment> experimentsUsingVariable = (ArrayList<Experiment>)variableIdToExperiments.get(usageInstance.getId());
                if (experimentsUsingVariable == null) {
                    experimentsUsingVariable = new ArrayList<Experiment>();
                }
                experimentsUsingVariable.add(experiment);
                variableIdToExperiments.put(usageInstance.getId(), experimentsUsingVariable);
            }
        }
        return variableIdToExperiments;
    }

    public static Map<String, Map<String, LiveVariableUsageInstance>> generateVariationToLiveVariableUsageInstancesMap(List<Experiment> experiments) {
        HashMap<String, Map<String, LiveVariableUsageInstance>> liveVariableValueMap = new HashMap<String, Map<String, LiveVariableUsageInstance>>();
        for (Experiment experiment : experiments) {
            for (Variation variation : experiment.getVariations()) {
                if (variation.getLiveVariableUsageInstances() == null) continue;
                for (LiveVariableUsageInstance usageInstance : variation.getLiveVariableUsageInstances()) {
                    HashMap<String, LiveVariableUsageInstance> liveVariableIdToValueMap = (HashMap<String, LiveVariableUsageInstance>)liveVariableValueMap.get(variation.getId());
                    if (liveVariableIdToValueMap == null) {
                        liveVariableIdToValueMap = new HashMap<String, LiveVariableUsageInstance>();
                    }
                    liveVariableIdToValueMap.put(usageInstance.getId(), usageInstance);
                    liveVariableValueMap.put(variation.getId(), liveVariableIdToValueMap);
                }
            }
        }
        return liveVariableValueMap;
    }
}

