/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfigUtils;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class ProjectConfig {
    private final String accountId;
    private final String projectId;
    private final String revision;
    private final String version;
    private final boolean anonymizeIP;
    private final List<Group> groups;
    private final List<Experiment> experiments;
    private final List<Attribute> attributes;
    private final List<EventType> events;
    private final List<Audience> audiences;
    private final List<LiveVariable> liveVariables;
    private final Map<String, Experiment> experimentKeyMapping;
    private final Map<String, Attribute> attributeKeyMapping;
    private final Map<String, LiveVariable> liveVariableKeyMapping;
    private final Map<String, EventType> eventNameMapping;
    private final Map<String, Audience> audienceIdMapping;
    private final Map<String, Experiment> experimentIdMapping;
    private final Map<String, Group> groupIdMapping;
    private final Map<String, List<Experiment>> liveVariableIdToExperimentsMapping;
    private final Map<String, Map<String, LiveVariableUsageInstance>> variationToLiveVariableUsageInstanceMapping;

    public ProjectConfig(String accountId, String projectId, String version, String revision, List<Group> groups, List<Experiment> experiments, List<Attribute> attributes, List<EventType> eventType, List<Audience> audiences) {
        this(accountId, projectId, version, revision, groups, experiments, attributes, eventType, audiences, false, null);
    }

    public ProjectConfig(String accountId, String projectId, String version, String revision, List<Group> groups, List<Experiment> experiments, List<Attribute> attributes, List<EventType> eventType, List<Audience> audiences, boolean anonymizeIP, List<LiveVariable> liveVariables) {
        this.accountId = accountId;
        this.projectId = projectId;
        this.version = version;
        this.revision = revision;
        this.anonymizeIP = anonymizeIP;
        this.groups = Collections.unmodifiableList(groups);
        ArrayList<Experiment> allExperiments = new ArrayList<Experiment>();
        allExperiments.addAll(experiments);
        allExperiments.addAll(this.aggregateGroupExperiments(groups));
        this.experiments = Collections.unmodifiableList(allExperiments);
        this.attributes = Collections.unmodifiableList(attributes);
        this.events = Collections.unmodifiableList(eventType);
        this.audiences = Collections.unmodifiableList(audiences);
        this.experimentKeyMapping = ProjectConfigUtils.generateNameMapping(this.experiments);
        this.attributeKeyMapping = ProjectConfigUtils.generateNameMapping(attributes);
        this.eventNameMapping = ProjectConfigUtils.generateNameMapping(this.events);
        this.audienceIdMapping = ProjectConfigUtils.generateIdMapping(audiences);
        this.experimentIdMapping = ProjectConfigUtils.generateIdMapping(this.experiments);
        this.groupIdMapping = ProjectConfigUtils.generateIdMapping(groups);
        if (liveVariables == null) {
            this.liveVariables = null;
            this.liveVariableKeyMapping = Collections.emptyMap();
            this.liveVariableIdToExperimentsMapping = Collections.emptyMap();
            this.variationToLiveVariableUsageInstanceMapping = Collections.emptyMap();
        } else {
            this.liveVariables = Collections.unmodifiableList(liveVariables);
            this.liveVariableKeyMapping = ProjectConfigUtils.generateNameMapping(this.liveVariables);
            this.liveVariableIdToExperimentsMapping = ProjectConfigUtils.generateLiveVariableIdToExperimentsMapping(this.experiments);
            this.variationToLiveVariableUsageInstanceMapping = ProjectConfigUtils.generateVariationToLiveVariableUsageInstancesMap(this.experiments);
        }
    }

    private List<Experiment> aggregateGroupExperiments(List<Group> groups) {
        ArrayList<Experiment> groupExperiments = new ArrayList<Experiment>();
        for (Group group : groups) {
            groupExperiments.addAll(group.getExperiments());
        }
        return groupExperiments;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean getAnonymizeIP() {
        return this.anonymizeIP;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Experiment> getExperiments() {
        return this.experiments;
    }

    public List<Experiment> getExperimentsForEventKey(String eventKey) {
        EventType event = this.eventNameMapping.get(eventKey);
        if (event != null) {
            List<String> experimentIds = event.getExperimentIds();
            ArrayList<Experiment> experiments = new ArrayList<Experiment>(experimentIds.size());
            for (String experimentId : experimentIds) {
                experiments.add(this.experimentIdMapping.get(experimentId));
            }
            return experiments;
        }
        return Collections.emptyList();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<EventType> getEventTypes() {
        return this.events;
    }

    public List<Audience> getAudiences() {
        return this.audiences;
    }

    public Condition getAudienceConditionsFromId(String audienceId) {
        Audience audience = this.audienceIdMapping.get(audienceId);
        return audience != null ? audience.getConditions() : null;
    }

    public List<LiveVariable> getLiveVariables() {
        return this.liveVariables;
    }

    public Map<String, Experiment> getExperimentKeyMapping() {
        return this.experimentKeyMapping;
    }

    public Map<String, Attribute> getAttributeKeyMapping() {
        return this.attributeKeyMapping;
    }

    public Map<String, EventType> getEventNameMapping() {
        return this.eventNameMapping;
    }

    public Map<String, Audience> getAudienceIdMapping() {
        return this.audienceIdMapping;
    }

    public Map<String, Experiment> getExperimentIdMapping() {
        return this.experimentIdMapping;
    }

    public Map<String, Group> getGroupIdMapping() {
        return this.groupIdMapping;
    }

    public Map<String, LiveVariable> getLiveVariableKeyMapping() {
        return this.liveVariableKeyMapping;
    }

    public Map<String, List<Experiment>> getLiveVariableIdToExperimentsMapping() {
        return this.liveVariableIdToExperimentsMapping;
    }

    public Map<String, Map<String, LiveVariableUsageInstance>> getVariationToLiveVariableUsageInstanceMapping() {
        return this.variationToLiveVariableUsageInstanceMapping;
    }

    public String toString() {
        return "ProjectConfig{accountId='" + this.accountId + '\'' + ", projectId='" + this.projectId + '\'' + ", revision='" + this.revision + '\'' + ", version='" + this.version + '\'' + ", anonymizeIP='" + this.anonymizeIP + '\'' + ", groups=" + this.groups + ", experiments=" + this.experiments + ", attributes=" + this.attributes + ", events=" + this.events + ", audiences=" + this.audiences + ", liveVariables=" + this.liveVariables + ", experimentKeyMapping=" + this.experimentKeyMapping + ", attributeKeyMapping=" + this.attributeKeyMapping + ", liveVariableKeyMapping=" + this.liveVariableKeyMapping + ", eventNameMapping=" + this.eventNameMapping + ", audienceIdMapping=" + this.audienceIdMapping + ", experimentIdMapping=" + this.experimentIdMapping + ", groupIdMapping=" + this.groupIdMapping + ", liveVariableIdToExperimentsMapping=" + this.liveVariableIdToExperimentsMapping + ", variationToLiveVariableUsageInstanceMapping=" + this.variationToLiveVariableUsageInstanceMapping + '}';
    }

    public static enum Version {
        V1("1"),
        V2("2"),
        V3("3");

        private final String version;

        private Version(String version) {
            this.version = version;
        }

        public String toString() {
            return this.version;
        }
    }
}

