/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.optimizely.ab.config.IdKeyMapped;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveVariable
implements IdKeyMapped {
    private final String id;
    private final String key;
    private final String defaultValue;
    private final VariableType type;
    private final VariableStatus status;

    @JsonCreator
    public LiveVariable(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="defaultValue") String defaultValue, @JsonProperty(value="status") VariableStatus status, @JsonProperty(value="type") VariableType type) {
        this.id = id;
        this.key = key;
        this.defaultValue = defaultValue;
        this.status = status;
        this.type = type;
    }

    public VariableStatus getStatus() {
        return this.status;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public VariableType getType() {
        return this.type;
    }

    public String toString() {
        return "LiveVariable{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", type=" + (Object)((Object)this.type) + ", status=" + (Object)((Object)this.status) + '}';
    }

    public static enum VariableType {
        BOOLEAN("boolean"),
        INTEGER("integer"),
        STRING("string"),
        DOUBLE("double");

        private final String variableType;

        private VariableType(String variableType) {
            this.variableType = variableType;
        }

        @JsonValue
        public String getVariableType() {
            return this.variableType;
        }

        public static VariableType fromString(String variableTypeString) {
            if (variableTypeString != null) {
                for (VariableType variableTypeEnum : VariableType.values()) {
                    if (!variableTypeString.equals(variableTypeEnum.getVariableType())) continue;
                    return variableTypeEnum;
                }
            }
            return null;
        }
    }

    public static enum VariableStatus {
        ACTIVE("active"),
        ARCHIVED("archived");

        private final String variableStatus;

        private VariableStatus(String variableStatus) {
            this.variableStatus = variableStatus;
        }

        @JsonValue
        public String getVariableStatus() {
            return this.variableStatus;
        }

        public static VariableStatus fromString(String variableStatusString) {
            if (variableStatusString != null) {
                for (VariableStatus variableStatusEnum : VariableStatus.values()) {
                    if (!variableStatusString.equals(variableStatusEnum.getVariableStatus())) continue;
                    return variableStatusEnum;
                }
            }
            return null;
        }
    }
}

