/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MurmurHash3 {
    private MurmurHash3() {
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH", "SF_SWITCH_NO_DEFAULT"}, justification="deliberate")
    public static int murmurhash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int murmurhash3_x86_32(CharSequence data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int pos = offset;
        int end = offset + len;
        int k1 = 0;
        int shift = 0;
        int nBytes = 0;
        while (pos < end) {
            int bits;
            int k2;
            int code;
            if ((code = data.charAt(pos++)) < 128) {
                k2 = code;
                bits = 8;
            } else if (code < 2048) {
                k2 = 0xC0 | code >> 6 | (0x80 | code & 0x3F) << 8;
                bits = 16;
            } else if (code < 55296 || code > 57343 || pos >= end) {
                k2 = 0xE0 | code >> 12 | (0x80 | code >> 6 & 0x3F) << 8 | (0x80 | code & 0x3F) << 16;
                bits = 24;
            } else {
                int utf32 = data.charAt(pos++);
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                k2 = 0xFF & (0xF0 | utf32 >> 18) | (0x80 | utf32 >> 12 & 0x3F) << 8 | (0x80 | utf32 >> 6 & 0x3F) << 16 | (0x80 | utf32 & 0x3F) << 24;
                bits = 32;
            }
            k1 |= k2 << shift;
            if ((shift += bits) < 32) continue;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
            k1 = (shift -= 32) != 0 ? k2 >>> bits - shift : 0;
            nBytes += 4;
        }
        if (shift > 0) {
            nBytes += shift >> 3;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
        }
        h1 ^= nBytes;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

