/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.bucketing.Bucketer;
import com.optimizely.ab.bucketing.Decision;
import com.optimizely.ab.bucketing.UserProfile;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.bucketing.UserProfileUtils;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.internal.ExperimentUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionService {
    private final Bucketer bucketer;
    private final ErrorHandler errorHandler;
    private final ProjectConfig projectConfig;
    private final UserProfileService userProfileService;
    private static final Logger logger = LoggerFactory.getLogger(DecisionService.class);

    public DecisionService(@Nonnull Bucketer bucketer, @Nonnull ErrorHandler errorHandler, @Nonnull ProjectConfig projectConfig, @Nullable UserProfileService userProfileService) {
        this.bucketer = bucketer;
        this.errorHandler = errorHandler;
        this.projectConfig = projectConfig;
        this.userProfileService = userProfileService;
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, String> filteredAttributes) {
        if (!ExperimentUtils.isExperimentActive(experiment)) {
            return null;
        }
        Variation variation = this.getWhitelistedVariation(experiment, userId);
        if (variation != null) {
            return variation;
        }
        UserProfile userProfile = null;
        if (this.userProfileService != null) {
            try {
                Map<String, Object> userProfileMap = this.userProfileService.lookup(userId);
                if (userProfileMap == null) {
                    logger.info("We were unable to get a user profile map from the UserProfileService.");
                } else if (UserProfileUtils.isValidUserProfileMap(userProfileMap)) {
                    userProfile = UserProfileUtils.convertMapToUserProfile(userProfileMap);
                } else {
                    logger.warn("The UserProfileService returned an invalid map.");
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                this.errorHandler.handleError(new OptimizelyRuntimeException(exception));
            }
        }
        if (userProfile != null) {
            variation = this.getStoredVariation(experiment, userProfile);
            if (variation != null) {
                return variation;
            }
        } else {
            userProfile = new UserProfile(userId, new HashMap<String, Decision>());
        }
        if (ExperimentUtils.isUserInExperiment(this.projectConfig, experiment, filteredAttributes)) {
            variation = this.bucketer.bucket(experiment, userId);
            if (variation != null) {
                if (this.userProfileService != null) {
                    this.saveVariation(experiment, variation, userProfile);
                } else {
                    logger.info("This decision will not be saved since the UserProfileService is null.");
                }
            }
            return variation;
        }
        logger.info("User \"{}\" does not meet conditions to be in experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
        return null;
    }

    @Nullable
    Variation getWhitelistedVariation(@Nonnull Experiment experiment, @Nonnull String userId) {
        Map<String, String> userIdToVariationKeyMap = experiment.getUserIdToVariationKeyMap();
        if (userIdToVariationKeyMap.containsKey(userId)) {
            String forcedVariationKey = userIdToVariationKeyMap.get(userId);
            Variation forcedVariation = experiment.getVariationKeyToVariationMap().get(forcedVariationKey);
            if (forcedVariation != null) {
                logger.info("User \"{}\" is forced in variation \"{}\".", (Object)userId, (Object)forcedVariationKey);
            } else {
                logger.error("Variation \"{}\" is not in the datafile. Not activating user \"{}\".", (Object)forcedVariationKey, (Object)userId);
            }
            return forcedVariation;
        }
        return null;
    }

    @Nullable
    Variation getStoredVariation(@Nonnull Experiment experiment, @Nonnull UserProfile userProfile) {
        String experimentId = experiment.getId();
        String experimentKey = experiment.getKey();
        Decision decision = userProfile.experimentBucketMap.get(experimentId);
        if (decision != null) {
            String variationId = decision.variationId;
            Variation savedVariation = this.projectConfig.getExperimentIdMapping().get(experimentId).getVariationIdToVariationMap().get(variationId);
            if (savedVariation != null) {
                logger.info("Returning previously activated variation \"{}\" of experiment \"{}\" for user \"{}\" from user profile.", new Object[]{savedVariation.getKey(), experimentKey, userProfile.userId});
                return savedVariation;
            }
            logger.info("User \"{}\" was previously bucketed into variation with ID \"{}\" for experiment \"{}\", but no matching variation was found for that user. We will re-bucket the user.", new Object[]{userProfile.userId, variationId, experimentKey});
            return null;
        }
        logger.info("No previously activated variation of experiment \"{}\" for user \"{}\" found in user profile.", (Object)experimentKey, (Object)userProfile.userId);
        return null;
    }

    void saveVariation(@Nonnull Experiment experiment, @Nonnull Variation variation, @Nonnull UserProfile userProfile) {
        if (this.userProfileService != null) {
            Decision decision;
            String experimentId = experiment.getId();
            String variationId = variation.getId();
            if (userProfile.experimentBucketMap.containsKey(experimentId)) {
                decision = userProfile.experimentBucketMap.get(experimentId);
                decision.variationId = variationId;
            } else {
                decision = new Decision(variationId);
            }
            userProfile.experimentBucketMap.put(experimentId, decision);
            try {
                this.userProfileService.save(userProfile.toMap());
                logger.info("Saved variation \"{}\" of experiment \"{}\" for user \"{}\".", new Object[]{variationId, experimentId, userProfile.userId});
            }
            catch (Exception exception) {
                logger.warn("Failed to save variation \"{}\" of experiment \"{}\" for user \"{}\".", new Object[]{variationId, experimentId, userProfile.userId});
                this.errorHandler.handleError(new OptimizelyRuntimeException(exception));
            }
        }
    }
}

