/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.bucketing.internal.MurmurHash3;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Bucketer {
    private final ProjectConfig projectConfig;
    private static final Logger logger = LoggerFactory.getLogger(Bucketer.class);
    private static final int MURMUR_HASH_SEED = 1;
    @VisibleForTesting
    static final int MAX_TRAFFIC_VALUE = 10000;

    public Bucketer(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    private String bucketToEntity(int bucketValue, List<TrafficAllocation> trafficAllocations) {
        for (TrafficAllocation currAllocation : trafficAllocations) {
            int currentEndOfRange = currAllocation.getEndOfRange();
            if (bucketValue >= currentEndOfRange) continue;
            if (currAllocation.getEntityId().isEmpty()) {
                return null;
            }
            return currAllocation.getEntityId();
        }
        return null;
    }

    private Experiment bucketToExperiment(@Nonnull Group group, @Nonnull String userId) {
        String bucketId = userId + group.getId();
        List<TrafficAllocation> trafficAllocations = group.getTrafficAllocation();
        int hashCode = MurmurHash3.murmurhash3_x86_32(bucketId, 0, bucketId.length(), 1);
        int bucketValue = this.generateBucketValue(hashCode);
        logger.debug("Assigned bucket {} to user \"{}\" during experiment bucketing.", (Object)bucketValue, (Object)userId);
        String bucketedExperimentId = this.bucketToEntity(bucketValue, trafficAllocations);
        if (bucketedExperimentId != null) {
            return this.projectConfig.getExperimentIdMapping().get(bucketedExperimentId);
        }
        logger.info("User \"{}\" is not in any experiment of group {}.", (Object)userId, (Object)group.getId());
        return null;
    }

    private Variation bucketToVariation(@Nonnull Experiment experiment, @Nonnull String userId) {
        String experimentId = experiment.getId();
        String experimentKey = experiment.getKey();
        String combinedBucketId = userId + experimentId;
        List<TrafficAllocation> trafficAllocations = experiment.getTrafficAllocation();
        int hashCode = MurmurHash3.murmurhash3_x86_32(combinedBucketId, 0, combinedBucketId.length(), 1);
        int bucketValue = this.generateBucketValue(hashCode);
        logger.debug("Assigned bucket {} to user \"{}\" during variation bucketing.", (Object)bucketValue, (Object)userId);
        String bucketedVariationId = this.bucketToEntity(bucketValue, trafficAllocations);
        if (bucketedVariationId != null) {
            Variation bucketedVariation = experiment.getVariationIdToVariationMap().get(bucketedVariationId);
            String variationKey = bucketedVariation.getKey();
            logger.info("User \"{}\" is in variation \"{}\" of experiment \"{}\".", new Object[]{userId, variationKey, experimentKey});
            return bucketedVariation;
        }
        logger.info("User \"{}\" is not in any variation of experiment \"{}\".", (Object)userId, (Object)experimentKey);
        return null;
    }

    @Nullable
    public Variation bucket(@Nonnull Experiment experiment, @Nonnull String userId) {
        Group experimentGroup;
        String groupId = experiment.getGroupId();
        if (!groupId.isEmpty() && (experimentGroup = this.projectConfig.getGroupIdMapping().get(groupId)).getPolicy().equals("random")) {
            Experiment bucketedExperiment = this.bucketToExperiment(experimentGroup, userId);
            if (bucketedExperiment == null) {
                return null;
            }
            if (!bucketedExperiment.getId().equals(experiment.getId())) {
                logger.info("User \"{}\" is not in experiment \"{}\" of group {}.", new Object[]{userId, experiment.getKey(), experimentGroup.getId()});
                return null;
            }
            logger.info("User \"{}\" is in experiment \"{}\" of group {}.", new Object[]{userId, experiment.getKey(), experimentGroup.getId()});
        }
        return this.bucketToVariation(experiment, userId);
    }

    @VisibleForTesting
    int generateBucketValue(int hashCode) {
        double ratio = (double)((long)hashCode & 0xFFFFFFFFL) / Math.pow(2.0, 32.0);
        return (int)Math.floor(10000.0 * ratio);
    }
}

