/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.UnknownExperimentException;
import com.optimizely.ab.UnknownLiveVariableException;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.bucketing.Bucketer;
import com.optimizely.ab.bucketing.DecisionService;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.LiveVariable;
import com.optimizely.ab.config.LiveVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.DefaultConfigParser;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.error.NoOpErrorHandler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.EventBuilder;
import com.optimizely.ab.event.internal.EventBuilderV2;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.internal.EventTagUtils;
import com.optimizely.ab.internal.ReservedEventKey;
import com.optimizely.ab.notification.NotificationBroadcaster;
import com.optimizely.ab.notification.NotificationListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Optimizely {
    private static final Logger logger = LoggerFactory.getLogger(Optimizely.class);
    @VisibleForTesting
    final DecisionService decisionService;
    @VisibleForTesting
    final EventBuilder eventBuilder;
    @VisibleForTesting
    final ProjectConfig projectConfig;
    @VisibleForTesting
    final EventHandler eventHandler;
    @VisibleForTesting
    final ErrorHandler errorHandler;
    @VisibleForTesting
    final NotificationBroadcaster notificationBroadcaster = new NotificationBroadcaster();
    @Nullable
    private final UserProfileService userProfileService;

    private Optimizely(@Nonnull ProjectConfig projectConfig, @Nonnull DecisionService decisionService, @Nonnull EventHandler eventHandler, @Nonnull EventBuilder eventBuilder, @Nonnull ErrorHandler errorHandler, @Nullable UserProfileService userProfileService) {
        this.projectConfig = projectConfig;
        this.decisionService = decisionService;
        this.eventHandler = eventHandler;
        this.eventBuilder = eventBuilder;
        this.errorHandler = errorHandler;
        this.userProfileService = userProfileService;
    }

    @VisibleForTesting
    void initialize() {
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.activate(experimentKey, userId, Collections.<String, String>emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, String> attributes) throws UnknownExperimentException {
        if (!this.validateUserId(userId)) {
            logger.info("Not activating user for experiment \"{}\".", (Object)experimentKey);
            return null;
        }
        ProjectConfig currentConfig = this.getProjectConfig();
        Experiment experiment = this.getExperimentOrThrow(currentConfig, experimentKey);
        if (experiment == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experimentKey);
            return null;
        }
        return this.activate(currentConfig, experiment, userId, attributes);
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId) {
        return this.activate(experiment, userId, Collections.<String, String>emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, String> attributes) {
        ProjectConfig currentConfig = this.getProjectConfig();
        return this.activate(currentConfig, experiment, userId, attributes);
    }

    @Nullable
    private Variation activate(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, String> attributes) {
        Map<String, String> filteredAttributes = this.filterAttributes(projectConfig, attributes);
        Variation variation = this.decisionService.getVariation(experiment, userId, filteredAttributes);
        if (variation == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            return null;
        }
        if (experiment.isRunning()) {
            LogEvent impressionEvent = this.eventBuilder.createImpressionEvent(projectConfig, experiment, variation, userId, filteredAttributes);
            logger.info("Activating user \"{}\" in experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            logger.debug("Dispatching impression event to URL {} with params {} and payload \"{}\".", new Object[]{impressionEvent.getEndpointUrl(), impressionEvent.getRequestParams(), impressionEvent.getBody()});
            try {
                this.eventHandler.dispatchEvent(impressionEvent);
            }
            catch (Exception e) {
                logger.error("Unexpected exception in event dispatcher", (Throwable)e);
            }
            this.notificationBroadcaster.broadcastExperimentActivated(experiment, userId, filteredAttributes, variation);
        } else {
            logger.info("Experiment has \"Launched\" status so not dispatching event during activation.");
        }
        return variation;
    }

    public void track(@Nonnull String eventName, @Nonnull String userId) throws UnknownEventTypeException {
        this.track(eventName, userId, Collections.<String, String>emptyMap(), Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, String> attributes) throws UnknownEventTypeException {
        this.track(eventName, userId, attributes, Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, long eventValue) throws UnknownEventTypeException {
        this.track(eventName, userId, Collections.<String, String>emptyMap(), Collections.singletonMap(ReservedEventKey.REVENUE.toString(), eventValue));
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, String> attributes, long eventValue) throws UnknownEventTypeException {
        this.track(eventName, userId, attributes, Collections.singletonMap(ReservedEventKey.REVENUE.toString(), eventValue));
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, String> attributes, @Nonnull Map<String, ?> eventTags) throws UnknownEventTypeException {
        ProjectConfig currentConfig = this.getProjectConfig();
        EventType eventType = this.getEventTypeOrThrow(currentConfig, eventName);
        if (eventType == null) {
            logger.info("Not tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
            return;
        }
        Map<String, String> filteredAttributes = this.filterAttributes(currentConfig, attributes);
        Long eventValue = null;
        if (eventTags == null) {
            logger.warn("Event tags is null when non-null was expected. Defaulting to an empty event tags map.");
            eventTags = Collections.emptyMap();
        } else {
            eventValue = EventTagUtils.getRevenueValue(eventTags);
        }
        List<Experiment> experimentsForEvent = this.projectConfig.getExperimentsForEventKey(eventName);
        HashMap<Experiment, Variation> experimentVariationMap = new HashMap<Experiment, Variation>(experimentsForEvent.size());
        for (Experiment experiment : experimentsForEvent) {
            if (experiment.isRunning()) {
                Variation variation = this.decisionService.getVariation(experiment, userId, filteredAttributes);
                if (variation == null) continue;
                experimentVariationMap.put(experiment, variation);
                continue;
            }
            logger.info("Not tracking event \"{}\" for experiment \"{}\" because experiment has status \"Launched\".", (Object)eventType.getKey(), (Object)experiment.getKey());
        }
        LogEvent conversionEvent = this.eventBuilder.createConversionEvent(this.projectConfig, experimentVariationMap, userId, eventType.getId(), eventType.getKey(), filteredAttributes, eventTags);
        if (conversionEvent == null) {
            logger.info("There are no valid experiments for event \"{}\" to track.", (Object)eventName);
            logger.info("Not tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
            return;
        }
        logger.info("Tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
        logger.debug("Dispatching conversion event to URL {} with params {} and payload \"{}\".", new Object[]{conversionEvent.getEndpointUrl(), conversionEvent.getRequestParams(), conversionEvent.getBody()});
        try {
            this.eventHandler.dispatchEvent(conversionEvent);
        }
        catch (Exception e) {
            logger.error("Unexpected exception in event dispatcher", (Throwable)e);
        }
        this.notificationBroadcaster.broadcastEventTracked(eventName, userId, filteredAttributes, eventValue, conversionEvent);
    }

    @Nullable
    public String getVariableString(@Nonnull String variableKey, @Nonnull String userId, boolean activateExperiment) throws UnknownLiveVariableException {
        return this.getVariableString(variableKey, userId, Collections.<String, String>emptyMap(), activateExperiment);
    }

    @Nullable
    public String getVariableString(@Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, String> attributes, boolean activateExperiment) throws UnknownLiveVariableException {
        LiveVariable variable = this.getLiveVariableOrThrow(this.projectConfig, variableKey);
        if (variable == null) {
            return null;
        }
        List<Experiment> experimentsUsingLiveVariable = this.projectConfig.getLiveVariableIdToExperimentsMapping().get(variable.getId());
        Map<String, Map<String, LiveVariableUsageInstance>> variationToLiveVariableUsageInstanceMapping = this.projectConfig.getVariationToLiveVariableUsageInstanceMapping();
        if (experimentsUsingLiveVariable == null) {
            logger.warn("No experiment is using variable \"{}\".", (Object)variable.getKey());
            return variable.getDefaultValue();
        }
        for (Experiment experiment : experimentsUsingLiveVariable) {
            Variation variation = activateExperiment ? this.activate(experiment, userId, attributes) : this.getVariation(experiment, userId, attributes);
            if (variation == null) continue;
            LiveVariableUsageInstance usageInstance = variationToLiveVariableUsageInstanceMapping.get(variation.getId()).get(variable.getId());
            return usageInstance.getValue();
        }
        return variable.getDefaultValue();
    }

    @Nullable
    public Boolean getVariableBoolean(@Nonnull String variableKey, @Nonnull String userId, boolean activateExperiment) throws UnknownLiveVariableException {
        return this.getVariableBoolean(variableKey, userId, Collections.<String, String>emptyMap(), activateExperiment);
    }

    @Nullable
    public Boolean getVariableBoolean(@Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, String> attributes, boolean activateExperiment) throws UnknownLiveVariableException {
        String variableValueString = this.getVariableString(variableKey, userId, attributes, activateExperiment);
        if (variableValueString != null) {
            return Boolean.parseBoolean(variableValueString);
        }
        return null;
    }

    @Nullable
    public Integer getVariableInteger(@Nonnull String variableKey, @Nonnull String userId, boolean activateExperiment) throws UnknownLiveVariableException {
        return this.getVariableInteger(variableKey, userId, Collections.<String, String>emptyMap(), activateExperiment);
    }

    @Nullable
    public Integer getVariableInteger(@Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, String> attributes, boolean activateExperiment) throws UnknownLiveVariableException {
        String variableValueString = this.getVariableString(variableKey, userId, attributes, activateExperiment);
        if (variableValueString != null) {
            try {
                return Integer.parseInt(variableValueString);
            }
            catch (NumberFormatException e) {
                logger.error("Variable value \"{}\" for live variable \"{}\" is not an integer.", (Object)variableValueString, (Object)variableKey);
            }
        }
        return null;
    }

    @Nullable
    public Double getVariableDouble(@Nonnull String variableKey, @Nonnull String userId, boolean activateExperiment) throws UnknownLiveVariableException {
        return this.getVariableDouble(variableKey, userId, Collections.<String, String>emptyMap(), activateExperiment);
    }

    @Nullable
    public Double getVariableDouble(@Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, String> attributes, boolean activateExperiment) throws UnknownLiveVariableException {
        String variableValueString = this.getVariableString(variableKey, userId, attributes, activateExperiment);
        if (variableValueString != null) {
            try {
                return Double.parseDouble(variableValueString);
            }
            catch (NumberFormatException e) {
                logger.error("Variable value \"{}\" for live variable \"{}\" is not a double.", (Object)variableValueString, (Object)variableKey);
            }
        }
        return null;
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experiment, userId, Collections.<String, String>emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, String> attributes) throws UnknownExperimentException {
        Map<String, String> filteredAttributes = this.filterAttributes(this.projectConfig, attributes);
        return this.decisionService.getVariation(experiment, userId, filteredAttributes);
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experimentKey, userId, Collections.<String, String>emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, String> attributes) {
        if (!this.validateUserId(userId)) {
            return null;
        }
        ProjectConfig currentConfig = this.getProjectConfig();
        Experiment experiment = this.getExperimentOrThrow(currentConfig, experimentKey);
        if (experiment == null) {
            return null;
        }
        Map<String, String> filteredAttributes = this.filterAttributes(this.projectConfig, attributes);
        return this.decisionService.getVariation(experiment, userId, filteredAttributes);
    }

    @Nonnull
    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    private static ProjectConfig getProjectConfig(String datafile) throws ConfigParseException {
        if (datafile == null) {
            throw new ConfigParseException("Unable to parse null datafile.");
        }
        if (datafile.length() == 0) {
            throw new ConfigParseException("Unable to parse empty datafile.");
        }
        ProjectConfig projectConfig = DefaultConfigParser.getInstance().parseProjectConfig(datafile);
        if (projectConfig.getVersion().equals("1")) {
            throw new ConfigParseException("This version of the Java SDK does not support version 1 datafiles. Please use a version 2 or 3 datafile with this SDK.");
        }
        return projectConfig;
    }

    @Nullable
    public UserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    public void addNotificationListener(@Nonnull NotificationListener listener) {
        this.notificationBroadcaster.addListener(listener);
    }

    public void removeNotificationListener(@Nonnull NotificationListener listener) {
        this.notificationBroadcaster.removeListener(listener);
    }

    public void clearNotificationListeners() {
        this.notificationBroadcaster.clearListeners();
    }

    @CheckForNull
    private Experiment getExperimentOrThrow(@Nonnull ProjectConfig projectConfig, @Nonnull String experimentKey) throws UnknownExperimentException {
        Experiment experiment = projectConfig.getExperimentKeyMapping().get(experimentKey);
        if (experiment == null) {
            String unknownExperimentError = String.format("Experiment \"%s\" is not in the datafile.", experimentKey);
            logger.error(unknownExperimentError);
            this.errorHandler.handleError(new UnknownExperimentException(unknownExperimentError));
        }
        return experiment;
    }

    private EventType getEventTypeOrThrow(ProjectConfig projectConfig, String eventName) throws UnknownEventTypeException {
        EventType eventType = projectConfig.getEventNameMapping().get(eventName);
        if (eventType == null) {
            String unknownEventTypeError = String.format("Event \"%s\" is not in the datafile.", eventName);
            logger.error(unknownEventTypeError);
            this.errorHandler.handleError(new UnknownEventTypeException(unknownEventTypeError));
        }
        return eventType;
    }

    private LiveVariable getLiveVariableOrThrow(ProjectConfig projectConfig, String variableKey) throws UnknownLiveVariableException {
        LiveVariable liveVariable = projectConfig.getLiveVariableKeyMapping().get(variableKey);
        if (liveVariable == null) {
            String unknownLiveVariableKeyError = String.format("Live variable \"%s\" is not in the datafile.", variableKey);
            logger.error(unknownLiveVariableKeyError);
            this.errorHandler.handleError(new UnknownLiveVariableException(unknownLiveVariableKeyError));
        }
        return liveVariable;
    }

    private Map<String, String> filterAttributes(@Nonnull ProjectConfig projectConfig, @Nonnull Map<String, String> attributes) {
        if (attributes == null) {
            logger.warn("Attributes is null when non-null was expected. Defaulting to an empty attributes map.");
            return Collections.emptyMap();
        }
        ArrayList<String> unknownAttributes = null;
        Map<String, Attribute> attributeKeyMapping = projectConfig.getAttributeKeyMapping();
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            if (attributeKeyMapping.containsKey(attribute.getKey())) continue;
            if (unknownAttributes == null) {
                unknownAttributes = new ArrayList<String>();
            }
            unknownAttributes.add(attribute.getKey());
        }
        if (unknownAttributes != null) {
            logger.warn("Attribute(s) {} not in the datafile.", unknownAttributes);
            attributes = new HashMap<String, String>(attributes);
            for (String unknownAttribute : unknownAttributes) {
                attributes.remove(unknownAttribute);
            }
        }
        return attributes;
    }

    private boolean validateUserId(String userId) {
        if (userId.trim().isEmpty()) {
            logger.error("Non-empty user ID required");
            return false;
        }
        return true;
    }

    public static Builder builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
        return new Builder(datafile, eventHandler);
    }

    public static class Builder {
        private String datafile;
        private Bucketer bucketer;
        private DecisionService decisionService;
        private ErrorHandler errorHandler;
        private EventHandler eventHandler;
        private EventBuilder eventBuilder;
        private Event.ClientEngine clientEngine;
        private String clientVersion;
        private ProjectConfig projectConfig;
        private UserProfileService userProfileService;

        public Builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
            this.datafile = datafile;
            this.eventHandler = eventHandler;
        }

        protected Builder withBucketing(Bucketer bucketer) {
            this.bucketer = bucketer;
            return this;
        }

        protected Builder withDecisionService(DecisionService decisionService) {
            this.decisionService = decisionService;
            return this;
        }

        public Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withUserProfileService(UserProfileService userProfileService) {
            this.userProfileService = userProfileService;
            return this;
        }

        public Builder withClientEngine(Event.ClientEngine clientEngine) {
            this.clientEngine = clientEngine;
            return this;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        protected Builder withEventBuilder(EventBuilder eventBuilder) {
            this.eventBuilder = eventBuilder;
            return this;
        }

        protected Builder withConfig(ProjectConfig projectConfig) {
            this.projectConfig = projectConfig;
            return this;
        }

        public Optimizely build() throws ConfigParseException {
            if (this.projectConfig == null) {
                this.projectConfig = Optimizely.getProjectConfig(this.datafile);
            }
            if (this.bucketer == null) {
                this.bucketer = new Bucketer(this.projectConfig);
            }
            if (this.clientEngine == null) {
                this.clientEngine = Event.ClientEngine.JAVA_SDK;
            }
            if (this.clientVersion == null) {
                this.clientVersion = BuildVersionInfo.VERSION;
            }
            if (this.eventBuilder == null) {
                this.eventBuilder = new EventBuilderV2(this.clientEngine, this.clientVersion);
            }
            if (this.errorHandler == null) {
                this.errorHandler = new NoOpErrorHandler();
            }
            if (this.decisionService == null) {
                this.decisionService = new DecisionService(this.bucketer, this.errorHandler, this.projectConfig, this.userProfileService);
            }
            Optimizely optimizely = new Optimizely(this.projectConfig, this.decisionService, this.eventHandler, this.eventBuilder, this.errorHandler, this.userProfileService);
            optimizely.initialize();
            return optimizely;
        }
    }
}

