/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import com.optimizely.ab.Optimizely;
import com.optimizely.ab.android.datafile_handler.DatafileHandler;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DefaultDatafileHandler;
import com.optimizely.ab.android.event_handler.DefaultEventHandler;
import com.optimizely.ab.android.sdk.OptimizelyClient;
import com.optimizely.ab.android.sdk.OptimizelyClientEngine;
import com.optimizely.ab.android.sdk.OptimizelyDefaultAttributes;
import com.optimizely.ab.android.sdk.OptimizelyLiteLogger;
import com.optimizely.ab.android.sdk.OptimizelyStartListener;
import com.optimizely.ab.android.shared.DatafileConfig;
import com.optimizely.ab.android.user_profile.DefaultUserProfileService;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.internal.payload.EventBatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizelyManager {
    @NonNull
    private OptimizelyClient optimizelyClient = new OptimizelyClient(null, LoggerFactory.getLogger(OptimizelyClient.class));
    @NonNull
    private DatafileHandler datafileHandler;
    private final long datafileDownloadInterval;
    private final long eventDispatchInterval;
    @Nullable
    private EventHandler eventHandler = null;
    @Nullable
    private ErrorHandler errorHandler;
    @NonNull
    private Logger logger;
    @Nullable
    private final String projectId;
    @Nullable
    private final String sdkKey;
    @NonNull
    private final DatafileConfig datafileConfig;
    @NonNull
    private UserProfileService userProfileService;
    @Nullable
    private OptimizelyStartListener optimizelyStartListener;

    OptimizelyManager(@Nullable String projectId, @Nullable String sdkKey, @Nullable DatafileConfig datafileConfig, @NonNull Logger logger, long datafileDownloadInterval, @NonNull DatafileHandler datafileHandler, @Nullable ErrorHandler errorHandler, long eventDispatchInterval, @NonNull EventHandler eventHandler, @NonNull UserProfileService userProfileService) {
        if (projectId == null && sdkKey == null) {
            logger.error("projectId and sdkKey are both null!");
        }
        this.projectId = projectId;
        this.sdkKey = sdkKey;
        this.datafileConfig = datafileConfig == null ? new DatafileConfig(this.projectId, this.sdkKey) : datafileConfig;
        this.logger = logger;
        this.datafileDownloadInterval = datafileDownloadInterval;
        this.datafileHandler = datafileHandler;
        this.eventDispatchInterval = eventDispatchInterval;
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
        this.userProfileService = userProfileService;
    }

    @VisibleForTesting
    public Long getDatafileDownloadInterval() {
        return this.datafileDownloadInterval;
    }

    @Deprecated
    @NonNull
    public static Builder builder(@Nullable String projectId) {
        return new Builder(projectId);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    OptimizelyStartListener getOptimizelyStartListener() {
        return this.optimizelyStartListener;
    }

    void setOptimizelyStartListener(@Nullable OptimizelyStartListener optimizelyStartListener) {
        this.optimizelyStartListener = optimizelyStartListener;
    }

    private void notifyStartListener() {
        if (this.optimizelyStartListener != null) {
            this.optimizelyStartListener.onStart(this.getOptimizely());
            this.optimizelyStartListener = null;
        }
    }

    public OptimizelyClient initialize(@NonNull Context context, @NonNull String datafile) {
        this.initialize(context, datafile, true);
        return this.optimizelyClient;
    }

    protected OptimizelyClient initialize(@NonNull Context context, @Nullable String datafile, boolean downloadToCache) {
        if (!this.isAndroidVersionSupported()) {
            return this.optimizelyClient;
        }
        try {
            if (datafile != null) {
                if (this.getUserProfileService() instanceof DefaultUserProfileService) {
                    DefaultUserProfileService defaultUserProfileService = (DefaultUserProfileService)this.getUserProfileService();
                    defaultUserProfileService.start();
                }
                this.optimizelyClient = this.buildOptimizely(context, datafile);
                if (this.datafileDownloadInterval > 0L && this.datafileHandler != null) {
                    this.datafileHandler.startBackgroundUpdates(context, this.datafileConfig, Long.valueOf(this.datafileDownloadInterval));
                }
            } else {
                this.logger.error("Invalid datafile");
            }
        }
        catch (ConfigParseException e) {
            this.logger.error("Unable to parse compiled data file", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
        catch (Error e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
        if (downloadToCache) {
            this.datafileHandler.downloadDatafile(context, this.datafileConfig, null);
        }
        return this.optimizelyClient;
    }

    @NonNull
    public OptimizelyClient initialize(@NonNull Context context, @RawRes Integer datafileRes) {
        try {
            Boolean datafileInCache = this.isDatafileCached(context);
            String datafile = this.getDatafile(context, datafileRes);
            this.optimizelyClient = this.initialize(context, datafile, true);
            if (datafileInCache.booleanValue()) {
                this.cleanupUserProfileCache(this.getUserProfileService());
            }
        }
        catch (NullPointerException e) {
            this.logger.error("Unable to find compiled data file in raw resource", (Throwable)e);
        }
        return this.optimizelyClient;
    }

    private void cleanupUserProfileCache(UserProfileService userProfileService) {
        if (!(userProfileService instanceof DefaultUserProfileService)) {
            return;
        }
        final DefaultUserProfileService defaultUserProfileService = (DefaultUserProfileService)userProfileService;
        final ProjectConfig config = this.optimizelyClient.getProjectConfig();
        if (config == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Set experimentIds = config.getExperimentIdMapping().keySet();
                    defaultUserProfileService.removeInvalidExperiments(experimentIds);
                }
                catch (Exception e) {
                    OptimizelyManager.this.logger.error("Error removing invalid experiments from default user profile service.", (Throwable)e);
                }
            }
        }).start();
    }

    public String getDatafile(Context context, @RawRes Integer datafileRes) {
        try {
            if (this.isDatafileCached(context)) {
                return this.datafileHandler.loadSavedDatafile(context, this.datafileConfig);
            }
            if (datafileRes != null) {
                return OptimizelyManager.loadRawResource(context, datafileRes);
            }
            this.logger.error("Invalid datafile resource ID.");
            return null;
        }
        catch (IOException e) {
            this.logger.error("Unable to load compiled data file", (Throwable)e);
        }
        catch (NullPointerException e) {
            this.logger.error("Unable to find compiled data file in raw resource", (Throwable)e);
        }
        return null;
    }

    @TargetApi(value=14)
    public void initialize(@NonNull Context context, @NonNull OptimizelyStartListener optimizelyStartListener) {
        this.initialize(context, null, optimizelyStartListener);
    }

    @TargetApi(value=14)
    public void initialize(@NonNull Context context, @RawRes Integer datafileRes, @NonNull OptimizelyStartListener optimizelyStartListener) {
        if (!this.isAndroidVersionSupported()) {
            return;
        }
        this.setOptimizelyStartListener(optimizelyStartListener);
        this.datafileHandler.downloadDatafile(context, this.datafileConfig, this.getDatafileLoadedListener(context, datafileRes));
    }

    DatafileLoadedListener getDatafileLoadedListener(final Context context, final @RawRes Integer datafileRes) {
        return new DatafileLoadedListener(){

            @RequiresApi(api=11)
            public void onDatafileLoaded(@Nullable String datafile) {
                if (datafile != null && !datafile.isEmpty()) {
                    OptimizelyManager.this.injectOptimizely(context, OptimizelyManager.this.userProfileService, datafile);
                } else {
                    OptimizelyManager.this.injectOptimizely(context, OptimizelyManager.this.userProfileService, OptimizelyManager.this.getDatafile(context, datafileRes));
                }
            }

            public void onStop(Context context2) {
            }
        };
    }

    @TargetApi(value=14)
    void stop(@NonNull Activity activity, @NonNull OptlyActivityLifecycleCallbacks optlyActivityLifecycleCallbacks) {
        this.stop((Context)activity);
        activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)optlyActivityLifecycleCallbacks);
    }

    public void stop(@NonNull Context context) {
        if (!this.isAndroidVersionSupported()) {
            return;
        }
        this.optimizelyStartListener = null;
    }

    @NonNull
    public OptimizelyClient getOptimizely() {
        this.isAndroidVersionSupported();
        return this.optimizelyClient;
    }

    public static String loadRawResource(Context context, @RawRes int rawRes) throws IOException {
        byte[] b;
        Resources res = context.getResources();
        InputStream in = res.openRawResource(rawRes);
        int read = in.read(b = new byte[in.available()]);
        if (read > -1) {
            return new String(b);
        }
        throw new IOException("Couldn't parse raw res fixture, no bytes");
    }

    public boolean isDatafileCached(Context context) {
        return this.datafileHandler.isDatafileSaved(context, this.datafileConfig);
    }

    @NonNull
    public String getDatafileUrl() {
        return this.datafileConfig.getUrl();
    }

    @NonNull
    public String getProjectId() {
        return this.projectId;
    }

    @NonNull
    public DatafileConfig getDatafileConfig() {
        return this.datafileConfig;
    }

    @NonNull
    public DatafileHandler getDatafileHandler() {
        return this.datafileHandler;
    }

    @RequiresApi(api=11)
    void injectOptimizely(@NonNull Context context, @NonNull UserProfileService userProfileService, @NonNull String datafile) {
        if (this.datafileDownloadInterval > 0L && this.datafileHandler != null) {
            this.datafileHandler.startBackgroundUpdates(context, this.datafileConfig, Long.valueOf(this.datafileDownloadInterval));
        }
        try {
            this.optimizelyClient = this.buildOptimizely(context, datafile);
            this.optimizelyClient.setDefaultAttributes(OptimizelyDefaultAttributes.buildDefaultAttributesMap(context, this.logger));
            if (userProfileService instanceof DefaultUserProfileService) {
                ((DefaultUserProfileService)userProfileService).startInBackground(new DefaultUserProfileService.StartCallback(){

                    public void onStartComplete(UserProfileService userProfileService) {
                        OptimizelyManager.this.cleanupUserProfileCache(userProfileService);
                        if (OptimizelyManager.this.optimizelyStartListener != null) {
                            OptimizelyManager.this.logger.info("Sending Optimizely instance to listener");
                            OptimizelyManager.this.notifyStartListener();
                        } else {
                            OptimizelyManager.this.logger.info("No listener to send Optimizely to");
                        }
                    }
                });
            } else if (this.optimizelyStartListener != null) {
                this.logger.info("Sending Optimizely instance to listener");
                this.notifyStartListener();
            } else {
                this.logger.info("No listener to send Optimizely to");
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
            if (this.optimizelyStartListener != null) {
                this.logger.info("Sending Optimizely instance to listener may be null on failure");
                this.notifyStartListener();
            }
        }
        catch (Error e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
    }

    private OptimizelyClient buildOptimizely(@NonNull Context context, @NonNull String datafile) throws ConfigParseException {
        EventHandler eventHandler = this.getEventHandler(context);
        EventBatch.ClientEngine clientEngine = OptimizelyClientEngine.getClientEngineFromContext(context);
        Optimizely.Builder builder = Optimizely.builder((String)datafile, (EventHandler)eventHandler).withClientEngine(clientEngine).withClientVersion("3.0.0");
        if (this.errorHandler != null) {
            builder.withErrorHandler(this.errorHandler);
        }
        if (this.userProfileService != null) {
            builder.withUserProfileService(this.userProfileService);
        } else {
            this.userProfileService = DefaultUserProfileService.newInstance((String)this.datafileConfig.getKey(), (Context)context);
            builder.withUserProfileService(this.userProfileService);
        }
        Optimizely optimizely = builder.build();
        return new OptimizelyClient(optimizely, LoggerFactory.getLogger(OptimizelyClient.class));
    }

    @NonNull
    @VisibleForTesting
    public UserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    protected EventHandler getEventHandler(Context context) {
        if (this.eventHandler == null) {
            DefaultEventHandler eventHandler = DefaultEventHandler.getInstance((Context)context);
            eventHandler.setDispatchInterval(this.eventDispatchInterval);
            this.eventHandler = eventHandler;
        }
        return this.eventHandler;
    }

    protected ErrorHandler getErrorHandler(Context context) {
        return this.errorHandler;
    }

    private boolean isAndroidVersionSupported() {
        if (Build.VERSION.SDK_INT >= 14) {
            return true;
        }
        this.logger.warn("Optimizely will not work on this phone.  It's Android version {} is less the minimum supported version {}", (Object)Build.VERSION.SDK_INT, (Object)14);
        return false;
    }

    public static class Builder {
        @Nullable
        private final String projectId;
        private long datafileDownloadInterval = -1L;
        private long eventDispatchInterval = -1L;
        @Nullable
        private DatafileHandler datafileHandler = null;
        @Nullable
        private Logger logger = null;
        @Nullable
        private EventHandler eventHandler = null;
        @Nullable
        private ErrorHandler errorHandler = null;
        @Nullable
        private UserProfileService userProfileService = null;
        @Nullable
        private String sdkKey = null;
        @Nullable
        private DatafileConfig datafileConfig = null;

        @Deprecated
        Builder(@Nullable String projectId) {
            this.projectId = projectId;
        }

        Builder() {
            this.projectId = null;
        }

        public Builder withDatafileDownloadInterval(long interval) {
            this.datafileDownloadInterval = interval;
            return this;
        }

        public Builder withDatafileHandler(DatafileHandler overrideHandler) {
            this.datafileHandler = overrideHandler;
            return this;
        }

        public Builder withSDKKey(String sdkKey) {
            this.sdkKey = sdkKey;
            return this;
        }

        public Builder withLogger(Logger overrideHandler) {
            this.logger = overrideHandler;
            return this;
        }

        public Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withEventDispatchInterval(long interval) {
            this.eventDispatchInterval = interval;
            return this;
        }

        public Builder withEventHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            return this;
        }

        public Builder withUserProfileService(UserProfileService userProfileService) {
            this.userProfileService = userProfileService;
            return this;
        }

        public Builder withDatafileConfig(DatafileConfig datafileConfig) {
            this.datafileConfig = datafileConfig;
            return this;
        }

        public OptimizelyManager build(Context context) {
            if (this.logger == null) {
                try {
                    this.logger = LoggerFactory.getLogger(OptimizelyManager.class);
                }
                catch (Exception e) {
                    try {
                        this.logger = LoggerFactory.getLogger((String)"com.optimizely.ab.android.sdk.OptimizelyManager");
                    }
                    catch (Exception e1) {
                        this.logger = new OptimizelyLiteLogger("com.optimizely.ab.android.sdk.OptimizelyManager");
                    }
                    this.logger.error("Unable to generate logger from class.", (Throwable)e);
                }
                catch (Error e) {
                    try {
                        this.logger = LoggerFactory.getLogger((String)"com.optimizely.ab.android.sdk.OptimizelyManager");
                        this.logger.error("Unable to generate logger from class.", (Throwable)e);
                    }
                    catch (Exception e1) {
                        this.logger = new OptimizelyLiteLogger("com.optimizely.ab.android.sdk.OptimizelyManager");
                    }
                }
            }
            if (this.datafileDownloadInterval > 0L && this.datafileDownloadInterval < 60L) {
                this.datafileDownloadInterval = 60L;
                this.logger.warn("Minimum datafile polling interval is 60 seconds. Defaulting to 60 seconds.");
            }
            if (this.datafileHandler == null) {
                this.datafileHandler = new DefaultDatafileHandler();
            }
            if (this.userProfileService == null) {
                DatafileConfig config = new DatafileConfig(this.projectId, this.sdkKey);
                this.userProfileService = DefaultUserProfileService.newInstance((String)config.getKey(), (Context)context);
            }
            if (this.eventHandler == null) {
                this.eventHandler = DefaultEventHandler.getInstance((Context)context);
            }
            if (this.projectId == null && this.sdkKey == null) {
                this.logger.error("ProjectId and SDKKey cannot both be null");
                return null;
            }
            return new OptimizelyManager(this.projectId, this.sdkKey, this.datafileConfig, this.logger, this.datafileDownloadInterval, this.datafileHandler, this.errorHandler, this.eventDispatchInterval, this.eventHandler, this.userProfileService);
        }
    }

    @RequiresApi(api=14)
    static class OptlyActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        @NonNull
        private OptimizelyManager optimizelyManager;

        OptlyActivityLifecycleCallbacks(@NonNull OptimizelyManager optimizelyManager) {
            this.optimizelyManager = optimizelyManager;
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            this.optimizelyManager.stop(activity, this);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

