/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class OptimizelyDefaultAttributes {
    private static final String DEVICE_MODEL_KEY = "optimizely_android_device_model";
    private static final String SDK_VERSION_KEY = "optimizely_android_sdk_version";
    private static final String OS_VERSION_KEY = "optimizely_android_os_version";
    private static final String APP_VERSION_KEY = "optimizely_android_app_version";

    static Map<String, String> buildDefaultAttributesMap(Context context, Logger logger) {
        String androidDeviceModel = Build.MODEL;
        String androidOSVersion = Build.VERSION.RELEASE;
        boolean androidSdkVersion = false;
        String androidSdkVersionName = "";
        String androidAppVersionName = "";
        int androidAppVersion = 0;
        try {
            androidSdkVersion = true;
            androidSdkVersionName = "1.4.0";
        }
        catch (Exception e) {
            logger.warn("Error getting BuildConfig version code and version name");
        }
        try {
            PackageInfo pInfo = context.getApplicationContext().getPackageManager().getPackageInfo(context.getApplicationContext().getPackageName(), 0);
            androidAppVersionName = pInfo.versionName;
            androidAppVersion = pInfo.versionCode;
        }
        catch (Exception e) {
            logger.warn("Error getting app version from context.", (Throwable)e);
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(DEVICE_MODEL_KEY, androidDeviceModel);
        attrMap.put(SDK_VERSION_KEY, androidSdkVersionName);
        attrMap.put(OS_VERSION_KEY, androidOSVersion);
        String appVersion = androidAppVersionName + Integer.toString(androidAppVersion);
        attrMap.put(APP_VERSION_KEY, appVersion);
        return attrMap;
    }
}

