/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.Optimizely;
import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.notification.NotificationListener;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class OptimizelyClient {
    private final Logger logger;
    @Nullable
    private Optimizely optimizely;
    @NonNull
    private Map<String, String> defaultAttributes = new HashMap<String, String>();

    OptimizelyClient(@Nullable Optimizely optimizely, @NonNull Logger logger) {
        this.optimizely = optimizely;
        this.logger = logger;
    }

    protected void setDefaultAttributes(@NonNull Map<String, String> attrs) {
        this.defaultAttributes = attrs;
    }

    @NonNull
    public Map<String, String> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    private Map<String, String> getAllAttributes(@NonNull Map<String, String> attrs) {
        HashMap<String, String> combinedMap = new HashMap<String, String>(this.defaultAttributes);
        combinedMap.putAll(attrs);
        return combinedMap;
    }

    @Nullable
    public Variation activate(@NonNull String experimentKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.activate(experimentKey, userId, this.getDefaultAttributes());
        }
        this.logger.warn("Optimizely is not initialized, could not activate experiment {} for user {}", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public Variation activate(@NonNull String experimentKey, @NonNull String userId, @NonNull Map<String, String> attributes) {
        if (this.isValid()) {
            return this.optimizely.activate(experimentKey, userId, this.getAllAttributes(attributes));
        }
        this.logger.warn("Optimizely is not initialized, could not activate experiment {} for user {} with attributes", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public ProjectConfig getProjectConfig() {
        if (this.isValid()) {
            return this.optimizely.getProjectConfig();
        }
        this.logger.warn("Optimizely is not initialized, could not get project config");
        return null;
    }

    public boolean isValid() {
        return this.optimizely != null;
    }

    public void track(@NonNull String eventName, @NonNull String userId) {
        if (this.isValid()) {
            try {
                this.optimizely.track(eventName, userId, this.getDefaultAttributes());
            }
            catch (Exception e) {
                this.logger.error("Unable to track event", (Throwable)e);
            }
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {}", (Object)eventName, (Object)userId);
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, @NonNull Map<String, String> attributes) throws UnknownEventTypeException {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getAllAttributes(attributes));
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with attributes", (Object)eventName, (Object)userId);
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, @NonNull Map<String, String> attributes, @NonNull Map<String, ?> eventTags) throws UnknownEventTypeException {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getAllAttributes(attributes), eventTags);
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with attributes and event tags", (Object)eventName, (Object)userId);
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, long eventValue) throws UnknownEventTypeException {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getDefaultAttributes(), eventValue);
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with value {}", new Object[]{eventName, userId, eventValue});
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, @NonNull Map<String, String> attributes, long eventValue) {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getAllAttributes(attributes), eventValue);
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with value {} and attributes", new Object[]{eventName, userId, eventValue});
        }
    }

    @Nullable
    public String getVariableString(@NonNull String variableKey, @NonNull String userId, boolean activateExperiment) {
        return this.getVariableString(variableKey, userId, this.getDefaultAttributes(), activateExperiment);
    }

    @Nullable
    public String getVariableString(@NonNull String variableKey, @NonNull String userId, @NonNull Map<String, String> attributes, boolean activateExperiment) {
        if (this.isValid()) {
            return this.optimizely.getVariableString(variableKey, userId, this.getAllAttributes(attributes), activateExperiment);
        }
        this.logger.warn("Optimizely is not initialized, could not get live variable {} for user {}", (Object)variableKey, (Object)userId);
        return null;
    }

    @Nullable
    public Boolean getVariableBoolean(@NonNull String variableKey, @NonNull String userId, boolean activateExperiment) {
        return this.getVariableBoolean(variableKey, userId, this.getDefaultAttributes(), activateExperiment);
    }

    @Nullable
    public Boolean getVariableBoolean(@NonNull String variableKey, @NonNull String userId, @NonNull Map<String, String> attributes, boolean activateExperiment) {
        if (this.isValid()) {
            return this.optimizely.getVariableBoolean(variableKey, userId, this.getAllAttributes(attributes), activateExperiment);
        }
        this.logger.warn("Optimizely is not initialized, could not get live variable {} for user {}", (Object)variableKey, (Object)userId);
        return null;
    }

    @Nullable
    public Integer getVariableInteger(@NonNull String variableKey, @NonNull String userId, boolean activateExperiment) {
        return this.getVariableInteger(variableKey, userId, this.getDefaultAttributes(), activateExperiment);
    }

    @Nullable
    public Integer getVariableInteger(@NonNull String variableKey, @NonNull String userId, @NonNull Map<String, String> attributes, boolean activateExperiment) {
        if (this.isValid()) {
            return this.optimizely.getVariableInteger(variableKey, userId, this.getAllAttributes(attributes), activateExperiment);
        }
        this.logger.warn("Optimizely is not initialized, could not get live variable {} for user {}", (Object)variableKey, (Object)userId);
        return null;
    }

    @Nullable
    public Double getVariableDouble(@NonNull String variableKey, @NonNull String userId, boolean activateExperiment) {
        return this.getVariableDouble(variableKey, userId, this.getDefaultAttributes(), activateExperiment);
    }

    @Nullable
    public Double getVariableDouble(@NonNull String variableKey, @NonNull String userId, @NonNull Map<String, String> attributes, boolean activateExperiment) {
        if (this.isValid()) {
            return this.optimizely.getVariableDouble(variableKey, userId, this.getAllAttributes(attributes), activateExperiment);
        }
        this.logger.warn("Optimizely is not initialized, could not get live variable {} for user {}", (Object)variableKey, (Object)userId);
        return null;
    }

    @Nullable
    public Variation getVariation(@NonNull String experimentKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getVariation(experimentKey, userId, this.getDefaultAttributes());
        }
        this.logger.warn("Optimizely is not initialized, could not get variation for experiment {} for user {}", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public Variation getVariation(@NonNull String experimentKey, @NonNull String userId, @NonNull Map<String, String> attributes) {
        if (this.isValid()) {
            return this.optimizely.getVariation(experimentKey, userId, this.getAllAttributes(attributes));
        }
        this.logger.warn("Optimizely is not initialized, could not get variation for experiment {} for user {} with attributes", (Object)experimentKey, (Object)userId);
        return null;
    }

    public void addNotificationListener(@NonNull NotificationListener listener) {
        if (this.isValid()) {
            this.optimizely.addNotificationListener(listener);
        } else {
            this.logger.warn("Optimizely is not initialized, could not add notification listener");
        }
    }

    public void removeNotificationListener(@NonNull NotificationListener listener) {
        if (this.isValid()) {
            this.optimizely.removeNotificationListener(listener);
        } else {
            this.logger.warn("Optimizely is not initialized, could not remove notification listener");
        }
    }

    public void clearNotificationListeners() {
        if (this.isValid()) {
            this.optimizely.clearNotificationListeners();
        } else {
            this.logger.warn("Optimizely is not initialized, could not clear notification listeners");
        }
    }
}

