/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.user_profile;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class UserProfileCacheUtils {
    public static Map<String, Map<String, Object>> convertJSONObjectToMap(JSONObject userProfilesJson) throws JSONException {
        ConcurrentHashMap<String, Map<String, Object>> userIdToUserProfileMap = new ConcurrentHashMap<String, Map<String, Object>>();
        Iterator userIdIterator = userProfilesJson.keys();
        while (userIdIterator.hasNext()) {
            String userId = (String)userIdIterator.next();
            JSONObject userProfileJson = userProfilesJson.getJSONObject(userId);
            ConcurrentHashMap experimentBucketMap = new ConcurrentHashMap();
            JSONObject experimentBucketMapJson = userProfileJson.getJSONObject("experiment_bucket_map");
            Iterator experimentIdIterator = experimentBucketMapJson.keys();
            while (experimentIdIterator.hasNext()) {
                String experimentId = (String)experimentIdIterator.next();
                JSONObject experimentBucketMapEntryJson = experimentBucketMapJson.getJSONObject(experimentId);
                String variationId = experimentBucketMapEntryJson.getString("variation_id");
                ConcurrentHashMap<String, String> decisionMap = new ConcurrentHashMap<String, String>();
                decisionMap.put("variation_id", variationId);
                experimentBucketMap.put(experimentId, decisionMap);
            }
            ConcurrentHashMap<String, Object> userProfileMap = new ConcurrentHashMap<String, Object>();
            userProfileMap.put("user_id", userId);
            userProfileMap.put("experiment_bucket_map", experimentBucketMap);
            userIdToUserProfileMap.put(userId, userProfileMap);
        }
        return userIdToUserProfileMap;
    }

    public static JSONObject convertMapToJSONObject(Map<String, Map<String, Object>> userProfilesMap) throws Exception {
        JSONObject userProfilesJson = new JSONObject();
        for (Map.Entry<String, Map<String, Object>> userProfileEntry : userProfilesMap.entrySet()) {
            Map<String, Object> userProfileMap = userProfileEntry.getValue();
            String userId = (String)userProfileMap.get("user_id");
            Map experimentBucketMap = (Map)userProfileMap.get("experiment_bucket_map");
            JSONObject experimentBucketMapJson = new JSONObject();
            for (Map.Entry experimentBucketMapEntry : experimentBucketMap.entrySet()) {
                String experimentId = (String)experimentBucketMapEntry.getKey();
                Map decisionsMap = (Map)experimentBucketMapEntry.getValue();
                JSONObject decisionJson = new JSONObject();
                decisionJson.put("variation_id", decisionsMap.get("variation_id"));
                experimentBucketMapJson.put(experimentId, (Object)decisionJson);
            }
            JSONObject userProfileJson = new JSONObject();
            userProfileJson.put("user_id", (Object)userId);
            userProfileJson.put("experiment_bucket_map", (Object)experimentBucketMapJson);
            userProfilesJson.put(userId, (Object)userProfileJson);
        }
        return userProfilesJson;
    }
}

