/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.user_experiment_record;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Pair;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.user_experiment_record.UserExperimentRecordCache;
import com.optimizely.ab.bucketing.UserExperimentRecord;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidUserExperimentRecord
implements UserExperimentRecord {
    @NonNull
    private final UserExperimentRecordCache diskUserExperimentRecordCache;
    @NonNull
    private final Logger logger;
    @NonNull
    private final WriteThroughCacheTaskFactory writeThroughCacheTaskFactory;

    AndroidUserExperimentRecord(@NonNull UserExperimentRecordCache diskUserExperimentRecordCache, @NonNull WriteThroughCacheTaskFactory writeThroughCacheTaskFactory, @NonNull Logger logger) {
        this.diskUserExperimentRecordCache = diskUserExperimentRecordCache;
        this.writeThroughCacheTaskFactory = writeThroughCacheTaskFactory;
        this.logger = logger;
    }

    public static UserExperimentRecord newInstance(@NonNull String projectId, @NonNull Context context) {
        ConcurrentHashMap<String, Map<String, String>> memoryUserExperimentRecordCache = new ConcurrentHashMap<String, Map<String, String>>();
        UserExperimentRecordCache userExperimentRecordCache = new UserExperimentRecordCache(projectId, new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(UserExperimentRecordCache.class));
        return new AndroidUserExperimentRecord(userExperimentRecordCache, new WriteThroughCacheTaskFactory(userExperimentRecordCache, memoryUserExperimentRecordCache, Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(WriteThroughCacheTaskFactory.class)), LoggerFactory.getLogger(AndroidUserExperimentRecord.class));
    }

    public void start() {
        try {
            JSONObject userIdToActivationJson = this.diskUserExperimentRecordCache.load();
            Iterator iterator1 = userIdToActivationJson.keys();
            while (iterator1.hasNext()) {
                String userId = (String)iterator1.next();
                JSONObject expIdToVarIdJson = userIdToActivationJson.getJSONObject(userId);
                Iterator iterator2 = expIdToVarIdJson.keys();
                while (iterator2.hasNext()) {
                    String expId = (String)iterator2.next();
                    String varId = expIdToVarIdJson.getString(expId);
                    Map<String, String> expIdToVarIdMap = this.writeThroughCacheTaskFactory.getMemoryUserExperimentRecordCache().get(userId);
                    if (expIdToVarIdMap == null) {
                        expIdToVarIdMap = new ConcurrentHashMap<String, String>();
                    }
                    expIdToVarIdMap.put(expId, varId);
                    this.writeThroughCacheTaskFactory.getMemoryUserExperimentRecordCache().put(userId, expIdToVarIdMap);
                }
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable to parse user experiment record cache", (Throwable)e);
        }
    }

    @RequiresApi(api=11)
    public boolean save(String userId, String experimentKey, String variationKey) {
        if (userId == null) {
            this.logger.error("Received null userId, unable to save activation");
            return false;
        }
        if (experimentKey == null) {
            this.logger.error("Received null experiment key, unable to save activation");
            return false;
        }
        if (variationKey == null) {
            this.logger.error("Received null variation key, unable to save activation");
            return false;
        }
        if (userId.isEmpty()) {
            this.logger.error("Received empty user id, unable to save activation");
            return false;
        }
        if (experimentKey.isEmpty()) {
            this.logger.error("Received empty experiment key, unable to save activation");
            return false;
        }
        if (variationKey.isEmpty()) {
            this.logger.error("Received empty variation key, unable to save activation");
            return false;
        }
        this.writeThroughCacheTaskFactory.startWriteCacheTask(userId, experimentKey, variationKey);
        return true;
    }

    @Nullable
    public String lookup(String userId, String experimentKey) {
        if (userId == null) {
            this.logger.error("Received null user id, unable to lookup activation");
            return null;
        }
        if (experimentKey == null) {
            this.logger.error("Received null experiment key, unable to lookup activation");
            return null;
        }
        if (userId.isEmpty()) {
            this.logger.error("Received empty user id, unable to lookup activation");
            return null;
        }
        if (experimentKey.isEmpty()) {
            this.logger.error("Received empty experiment key, unable to lookup activation");
            return null;
        }
        Map<String, String> expIdToVarIdMap = this.writeThroughCacheTaskFactory.getMemoryUserExperimentRecordCache().get(userId);
        String variationKey = null;
        if (expIdToVarIdMap != null) {
            variationKey = expIdToVarIdMap.get(experimentKey);
        }
        return variationKey;
    }

    @RequiresApi(api=11)
    public boolean remove(String userId, String experimentKey) {
        if (userId == null) {
            this.logger.error("Received null user id, unable to remove activation");
            return false;
        }
        if (experimentKey == null) {
            this.logger.error("Received null experiment key, unable to remove activation");
            return false;
        }
        if (userId.isEmpty()) {
            this.logger.error("Received empty user id, unable to remove activation");
            return false;
        }
        if (experimentKey.isEmpty()) {
            this.logger.error("Received empty experiment key, unable to remove activation");
            return false;
        }
        Map<String, String> expKeyToVarKeyMap = this.writeThroughCacheTaskFactory.getMemoryUserExperimentRecordCache().get(userId);
        if (expKeyToVarKeyMap == null) {
            return false;
        }
        if (expKeyToVarKeyMap.containsKey(experimentKey)) {
            this.writeThroughCacheTaskFactory.startRemoveCacheTask(userId, experimentKey, expKeyToVarKeyMap.get(experimentKey));
        }
        return true;
    }

    public Map<String, Map<String, String>> getAllRecords() {
        return this.writeThroughCacheTaskFactory.getMemoryUserExperimentRecordCache();
    }

    static class WriteThroughCacheTaskFactory {
        @NonNull
        private final UserExperimentRecordCache diskUserExperimentRecordCache;
        @NonNull
        private final Map<String, Map<String, String>> memoryUserExperimentRecordCache;
        @NonNull
        private final Executor executor;
        @NonNull
        private final Logger logger;

        WriteThroughCacheTaskFactory(@NonNull UserExperimentRecordCache diskUserExperimentRecordCache, @NonNull Map<String, Map<String, String>> memoryUserExperimentRecordCache, @NonNull Executor executor, @NonNull Logger logger) {
            this.diskUserExperimentRecordCache = diskUserExperimentRecordCache;
            this.memoryUserExperimentRecordCache = memoryUserExperimentRecordCache;
            this.executor = executor;
            this.logger = logger;
        }

        @NonNull
        Map<String, Map<String, String>> getMemoryUserExperimentRecordCache() {
            return this.memoryUserExperimentRecordCache;
        }

        @RequiresApi(api=11)
        void startWriteCacheTask(final String userId, final String experimentKey, final String variationKey) {
            AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void[] params) {
                    return WriteThroughCacheTaskFactory.this.diskUserExperimentRecordCache.save(userId, experimentKey, variationKey);
                }

                protected void onPreExecute() {
                    ConcurrentHashMap<String, String> expIdToVarIdMap = (ConcurrentHashMap<String, String>)WriteThroughCacheTaskFactory.this.memoryUserExperimentRecordCache.get(userId);
                    if (expIdToVarIdMap == null) {
                        expIdToVarIdMap = new ConcurrentHashMap<String, String>();
                    }
                    expIdToVarIdMap.put(experimentKey, variationKey);
                    WriteThroughCacheTaskFactory.this.memoryUserExperimentRecordCache.put(userId, expIdToVarIdMap);
                    WriteThroughCacheTaskFactory.this.logger.info("Updated in memory user experiment record");
                }

                protected void onPostExecute(Boolean success) {
                    if (success.booleanValue()) {
                        WriteThroughCacheTaskFactory.this.logger.info("Persisted user in variation {} for experiment {}.", (Object)variationKey, (Object)experimentKey);
                    } else {
                        ((Map)WriteThroughCacheTaskFactory.this.memoryUserExperimentRecordCache.get(userId)).remove(experimentKey);
                        WriteThroughCacheTaskFactory.this.logger.error("Failed to persist user in variation {} for experiment {}.", (Object)variationKey, (Object)experimentKey);
                    }
                }
            };
            task.executeOnExecutor(this.executor, (Object[])new Void[0]);
        }

        @RequiresApi(api=11)
        void startRemoveCacheTask(final String userId, final String experimentKey, final String variationKey) {
            AsyncTask<String, Void, Pair<String, Boolean>> task = new AsyncTask<String, Void, Pair<String, Boolean>>(){

                protected void onPreExecute() {
                    Map expIdToVarIdMap = (Map)WriteThroughCacheTaskFactory.this.memoryUserExperimentRecordCache.get(userId);
                    if (expIdToVarIdMap != null) {
                        expIdToVarIdMap.remove(experimentKey);
                        WriteThroughCacheTaskFactory.this.logger.info("Removed experimentKey: {} variationKey: {} record for user: {} from memory", new Object[]{experimentKey, variationKey, userId});
                    }
                }

                protected Pair<String, Boolean> doInBackground(String ... params) {
                    boolean success = WriteThroughCacheTaskFactory.this.diskUserExperimentRecordCache.remove(userId, experimentKey);
                    if (success) {
                        return new Pair((Object)params[0], (Object)true);
                    }
                    return new Pair((Object)params[0], (Object)false);
                }

                protected void onPostExecute(Pair<String, Boolean> result) {
                    if (!((Boolean)result.second).booleanValue()) {
                        ConcurrentHashMap<String, Object> expIdToVarIdMap = new ConcurrentHashMap<String, Object>();
                        expIdToVarIdMap.put(experimentKey, result.first);
                        WriteThroughCacheTaskFactory.this.memoryUserExperimentRecordCache.put(userId, expIdToVarIdMap);
                        WriteThroughCacheTaskFactory.this.logger.error("Restored experimentKey: {} variationKey: {} record for user: {} to memory", new Object[]{experimentKey, result.first, userId});
                    } else {
                        WriteThroughCacheTaskFactory.this.logger.info("Removed experimentKey: {} variationKey: {} record for user: {} from disk", new Object[]{experimentKey, result.first, userId});
                    }
                }
            };
            task.executeOnExecutor(this.executor, (Object[])new String[]{variationKey});
        }
    }
}

