/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.user_experiment_record;

import android.support.annotation.NonNull;
import com.optimizely.ab.android.shared.Cache;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

class UserExperimentRecordCache {
    private static final String FILE_NAME = "optly-user-experiment-record-%s.json";
    @NonNull
    private final String projectId;
    @NonNull
    private final Cache cache;
    @NonNull
    private final Logger logger;

    UserExperimentRecordCache(@NonNull String projectId, @NonNull Cache cache, @NonNull Logger logger) {
        this.projectId = projectId;
        this.cache = cache;
        this.logger = logger;
    }

    @NonNull
    JSONObject load() throws JSONException {
        String userExperimentRecord = null;
        try {
            userExperimentRecord = this.cache.load(this.getFileName());
        }
        catch (FileNotFoundException e) {
            this.logger.info("No user experiment record cache found");
        }
        catch (IOException e) {
            this.logger.error("Unable to load user experiment record cache", (Throwable)e);
        }
        if (userExperimentRecord == null) {
            return new JSONObject();
        }
        return new JSONObject(userExperimentRecord);
    }

    boolean remove(@NonNull String userId, @NonNull String experimentId) {
        try {
            JSONObject userExperimentRecord = this.load();
            JSONObject expIdToVarId = userExperimentRecord.getJSONObject(userId);
            expIdToVarId.remove(experimentId);
            return this.cache.save(this.getFileName(), userExperimentRecord.toString());
        }
        catch (IOException e) {
            this.logger.error("Unable to remove experiment for user from user experiment record cache", (Throwable)e);
            return false;
        }
        catch (JSONException e) {
            this.logger.error("Unable to remove experiment for user from user experiment record cache", (Throwable)e);
            return false;
        }
    }

    boolean save(@NonNull String userId, @NonNull String experimentId, @NonNull String variationId) {
        try {
            JSONObject userExperimentRecord = this.load();
            JSONObject expIdToVarId = userExperimentRecord.optJSONObject(userId);
            if (expIdToVarId == null) {
                expIdToVarId = new JSONObject();
            }
            expIdToVarId.put(experimentId, (Object)variationId);
            userExperimentRecord.put(userId, (Object)expIdToVarId);
            return this.cache.save(this.getFileName(), userExperimentRecord.toString());
        }
        catch (IOException e) {
            this.logger.error("Unable to save user experiment record cache", (Throwable)e);
            return false;
        }
        catch (JSONException e) {
            this.logger.error("Unable to parse user experiment record cache", (Throwable)e);
            return false;
        }
    }

    String getFileName() {
        return String.format(FILE_NAME, this.projectId);
    }
}

