/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.app.job.JobWorkItem;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.shared.JobWorkService;
import com.optimizely.ab.android.shared.ScheduledJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceScheduler {
    @NonNull
    private final PendingIntentFactory pendingIntentFactory;
    @NonNull
    private final Logger logger;
    @NonNull
    private final Context context;

    public ServiceScheduler(@NonNull Context context, @NonNull PendingIntentFactory pendingIntentFactory, @NonNull Logger logger) {
        this.pendingIntentFactory = pendingIntentFactory;
        this.logger = logger;
        this.context = context;
    }

    public void schedule(Intent intent, long interval) {
        if (interval < 1L) {
            this.logger.error("Tried to schedule an interval less than 1");
            return;
        }
        if (this.isScheduled(intent)) {
            this.unschedule(intent);
        }
        PendingIntent pendingIntent = this.pendingIntentFactory.getPendingIntent(intent);
        this.setRepeating(interval, pendingIntent, intent);
        this.logger.info("Scheduled {}", (Object)intent.getComponent().toShortString());
    }

    private void setRepeating(long interval, PendingIntent pendingIntent, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            int jobId = this.getJobId(intent);
            if (jobId == -1) {
                this.logger.error("Problem getting scheduled job id");
                return;
            }
            if (ServiceScheduler.isScheduled(this.context, jobId)) {
                this.logger.info("Job already started");
                return;
            }
            JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(jobId, new ComponentName(this.context.getApplicationContext(), ScheduledJobService.class.getName()));
            builder.setPeriodic(interval, interval);
            builder.setPersisted(true);
            builder.setRequiredNetworkType(1);
            builder.setBackoffCriteria(30000L, 0);
            intent.putExtra("com.optimizely.ab.android.shared.JobService.Periodic", interval);
            PersistableBundle persistableBundle = new PersistableBundle();
            block11: for (String key : intent.getExtras().keySet()) {
                Object object = intent.getExtras().get(key);
                switch (object.getClass().getSimpleName()) {
                    case "String": {
                        persistableBundle.putString(key, (String)object);
                        continue block11;
                    }
                    case "long": 
                    case "Long": {
                        persistableBundle.putLong(key, ((Long)object).longValue());
                        continue block11;
                    }
                }
                this.logger.info("No conversion for {}", (Object)object.getClass().getSimpleName());
            }
            persistableBundle.putString("com.optimizely.ab.android.shared.JobService.ComponentName", intent.getComponent().getClassName());
            builder.setExtras(persistableBundle);
            try {
                if (jobScheduler.schedule(builder.build()) != 1) {
                    this.logger.error("ServiceScheduler", (Object)"Some error while scheduling the job");
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("Problem scheduling job %s", intent.getComponent().toShortString()), (Throwable)e);
            }
        } else {
            AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
            alarmManager.setInexactRepeating(3, interval, interval, pendingIntent);
        }
    }

    private void cancelRepeating(PendingIntent pendingIntent, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
            String clazz = intent.getComponent().getClassName();
            Integer id = null;
            try {
                id = (Integer)Class.forName(clazz).getDeclaredField("JOB_ID").get(null);
                pendingIntent.cancel();
                if (ServiceScheduler.isScheduled(this.context, id)) {
                    jobScheduler.cancel(id.intValue());
                }
            }
            catch (Exception e) {
                this.logger.error("Error in Cancel ", (Throwable)e);
            }
        } else {
            AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
            pendingIntent.cancel();
        }
    }

    private int getJobId(Intent intent) {
        String clazz = "unknown";
        Integer id = null;
        try {
            clazz = intent.getComponent().getClassName();
            id = (Integer)Class.forName(clazz).getDeclaredField("JOB_ID").get(null);
        }
        catch (Exception e) {
            this.logger.error("Error getting JOB_ID from " + clazz, (Throwable)e);
        }
        return id == null ? -1 : id;
    }

    public void unschedule(Intent intent) {
        if (intent != null) {
            try {
                PendingIntent pendingIntent = this.pendingIntentFactory.getPendingIntent(intent);
                this.cancelRepeating(pendingIntent, intent);
                this.logger.info("Unscheduled {}", (Object)(intent.getComponent() != null ? intent.getComponent().toShortString() : "intent"));
            }
            catch (Exception e) {
                this.logger.debug("Failed to unschedule service", (Throwable)e);
            }
        }
    }

    public boolean isScheduled(Intent intent) {
        return this.pendingIntentFactory.hasPendingIntent(intent);
    }

    public static void startService(Context context, Integer jobId, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            JobInfo jobInfo = new JobInfo.Builder(jobId.intValue(), new ComponentName(context, JobWorkService.class)).setMinimumLatency(60000L).setOverrideDeadline(300000L).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            JobWorkItem jobWorkItem = new JobWorkItem(intent);
            try {
                jobScheduler.enqueue(jobInfo, jobWorkItem);
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ServiceScheduler").error("Problem enqueuing work item ", (Throwable)e);
            }
        } else {
            context.startService(intent);
        }
    }

    @RequiresApi(api=21)
    private static boolean isScheduled(Context context, Integer jobId) {
        if (Build.VERSION.SDK_INT >= 26) {
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != jobId.intValue() || !jobInfo.isPeriodic()) continue;
                return true;
            }
        }
        return false;
    }

    public static class PendingIntentFactory {
        private Context context;

        public PendingIntentFactory(Context context) {
            this.context = context;
        }

        public boolean hasPendingIntent(Intent intent) {
            return this.getPendingIntent(intent, 0x20000000) != null;
        }

        public PendingIntent getPendingIntent(Intent intent) {
            return this.getPendingIntent(intent, 0x8000000);
        }

        private PendingIntent getPendingIntent(Intent intent, int flag) {
            return PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)flag);
        }
    }
}

