/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.app.IntentService;
import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.support.annotation.RequiresApi;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresApi(api=26)
public class ScheduledJobService
extends JobService {
    public static final String INTENT_EXTRA_COMPONENT_NAME = "com.optimizely.ab.android.shared.JobService.ComponentName";
    public static final int ONE_MINUTE = 60000;
    private CommandProcessor mCurProcessor;
    private int startId = 1;
    Logger logger = LoggerFactory.getLogger(ScheduledJobService.class);

    public void onCreate() {
    }

    public void onDestroy() {
    }

    public boolean onStartJob(JobParameters params) {
        this.mCurProcessor = new CommandProcessor(params);
        this.mCurProcessor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        this.mCurProcessor.cancel(true);
        return true;
    }

    private void setContext(Service service) {
        this.callMethod(ContextWrapper.class, service, "attachBaseContext", new Class[]{Context.class}, this.getApplicationContext());
    }

    private void callOnStartCommand(Service service, Intent intent) {
        this.callMethod(Service.class, service, "onStartCommand", new Class[]{Intent.class, Integer.TYPE, Integer.TYPE}, intent, 0, 1);
    }

    private void callOnHandleIntent(IntentService intentService, Intent intent) {
        this.callMethod(IntentService.class, intentService, "onHandleIntent", new Class[]{Intent.class}, intent);
    }

    private void callMethod(Class clazz, Object object, String methodName, Class[] parameterTypes, Object ... parameters) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            method.invoke(object, parameters);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Error calling method " + methodName, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("Error calling method " + methodName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Error calling method " + methodName, (Throwable)e);
        }
    }

    final class CommandProcessor
    extends AsyncTask<Void, Void, Void> {
        private final JobParameters mParams;

        CommandProcessor(JobParameters params) {
            this.mParams = params;
        }

        protected Void doInBackground(Void ... params) {
            ScheduledJobService.this.logger.info("Processing schueduled service");
            try {
                PersistableBundle persistableBundle = this.mParams.getExtras();
                Class<?> clazz = Class.forName(persistableBundle.getString(ScheduledJobService.INTENT_EXTRA_COMPONENT_NAME));
                Object service = clazz.newInstance();
                ScheduledJobService.this.setContext((Service)service);
                Intent intent = new Intent(ScheduledJobService.this.getApplicationContext(), clazz);
                block11: for (String key : persistableBundle.keySet()) {
                    if (key == ScheduledJobService.INTENT_EXTRA_COMPONENT_NAME) continue;
                    Object object = persistableBundle.get(key);
                    switch (object.getClass().getSimpleName()) {
                        case "String": {
                            intent.putExtra(key, (String)object);
                            continue block11;
                        }
                        case "long": 
                        case "Long": {
                            intent.putExtra(key, (Serializable)((Long)object));
                            continue block11;
                        }
                    }
                    ScheduledJobService.this.logger.info("Extra key of type {}", (Object)object.getClass().getSimpleName());
                    if (!(object instanceof Parcelable)) continue;
                    intent.putExtra(key, (Parcelable)object);
                }
                if (service instanceof IntentService) {
                    IntentService intentService = (IntentService)service;
                    intentService.onCreate();
                    ScheduledJobService.this.callOnHandleIntent(intentService, intent);
                    ScheduledJobService.this.jobFinished(this.mParams, false);
                } else {
                    Handler mainHandler = new Handler(ScheduledJobService.this.getApplicationContext().getMainLooper());
                    final Service mainService = (Service)service;
                    final Intent manServiceIntent = intent;
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ScheduledJobService.this.callOnStartCommand(mainService, manServiceIntent);
                                ScheduledJobService.this.jobFinished(CommandProcessor.this.mParams, false);
                            }
                            catch (Exception e) {
                                ScheduledJobService.this.logger.error("Problem running service ", (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                ScheduledJobService.this.logger.error("Error creating ScheduledJobService", (Throwable)e);
            }
            return null;
        }
    }
}

