/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.optimizely.ab.android.shared.CachedCounter;
import com.optimizely.ab.android.shared.CountingIdlingResourceInterface;
import java.util.LinkedList;
import java.util.List;

public class CountingIdlingResourceManager {
    @Nullable
    private static CountingIdlingResourceInterface countingIdlingResource;
    @NonNull
    private static List<Pair<String, String>> eventList;

    @Nullable
    public static CountingIdlingResourceInterface getIdlingResource(Context context) {
        if (countingIdlingResource == null) {
            countingIdlingResource = new CachedCounter(context);
        }
        return countingIdlingResource;
    }

    public static void setIdlingResource(@NonNull CountingIdlingResourceInterface countingIdlingResource) {
        CountingIdlingResourceManager.countingIdlingResource = countingIdlingResource;
    }

    public static void increment() {
        if (countingIdlingResource != null) {
            countingIdlingResource.increment();
        }
    }

    public static void decrement() {
        if (countingIdlingResource != null) {
            countingIdlingResource.decrement();
        }
    }

    public static void recordEvent(Pair<String, String> event) {
        if (countingIdlingResource != null) {
            eventList.add(event);
        }
    }

    public static void clearEvents() {
        eventList.clear();
    }

    public static List<Pair<String, String>> getEvents() {
        return eventList;
    }

    static {
        eventList = new LinkedList<Pair<String, String>>();
    }
}

