/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.optimizely.ab.android.event_handler.EventIntentService;
import com.optimizely.ab.android.shared.ServiceScheduler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventHandler
implements EventHandler {
    @NonNull
    private final Context context;
    Logger logger = LoggerFactory.getLogger(DefaultEventHandler.class);
    private long dispatchInterval = -1L;

    private DefaultEventHandler(@NonNull Context context) {
        this.context = context;
    }

    public static DefaultEventHandler getInstance(@NonNull Context context) {
        return new DefaultEventHandler(context);
    }

    public void setDispatchInterval(long dispatchInterval) {
        this.dispatchInterval = dispatchInterval <= 0L ? -1L : dispatchInterval;
    }

    public void dispatchEvent(@NonNull LogEvent logEvent) {
        if (logEvent.getEndpointUrl() == null) {
            this.logger.error("Event dispatcher received a null url");
            return;
        }
        if (logEvent.getBody() == null) {
            this.logger.error("Event dispatcher received a null request body");
            return;
        }
        if (logEvent.getEndpointUrl().isEmpty()) {
            this.logger.error("Event dispatcher received an empty url");
        }
        Intent intent = new Intent(this.context, EventIntentService.class);
        intent.putExtra("com.optimizely.ab.android.EXTRA_URL", logEvent.getEndpointUrl());
        intent.putExtra("com.optimizely.ab.android.EXTRA_REQUEST_BODY", logEvent.getBody());
        intent.putExtra("com.optimizely.ab.android.EXTRA_INTERVAL", this.dispatchInterval);
        ServiceScheduler.startService((Context)this.context, (Integer)EventIntentService.JOB_ID, (Intent)intent);
        this.logger.info("Sent url {} to the event handler service", (Object)logEvent.getEndpointUrl());
    }
}

