/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.optimizely.ab.android.event_handler.EventIntentService;
import com.optimizely.ab.android.shared.ServiceScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRescheduler
extends BroadcastReceiver {
    Logger logger = LoggerFactory.getLogger(EventRescheduler.class);

    public void onReceive(Context context, Intent intent) {
        if (context != null && intent != null) {
            ServiceScheduler serviceScheduler = new ServiceScheduler((AlarmManager)context.getSystemService("alarm"), new ServiceScheduler.PendingIntentFactory(context), LoggerFactory.getLogger(ServiceScheduler.class));
            Intent eventServiceIntent = new Intent(context, EventIntentService.class);
            this.reschedule(context, intent, eventServiceIntent, serviceScheduler);
        } else {
            this.logger.warn("Received invalid broadcast to event rescheduler");
        }
    }

    void reschedule(@NonNull Context context, @NonNull Intent broadcastIntent, @NonNull Intent eventServiceIntent, @NonNull ServiceScheduler serviceScheduler) {
        if (broadcastIntent.getAction().equals("android.intent.action.BOOT_COMPLETED") || broadcastIntent.getAction().equals("android.intent.action.MY_PACKAGE_REPLACED")) {
            context.startService(eventServiceIntent);
            this.logger.info("Rescheduling event flushing if necessary");
        } else if (broadcastIntent.getAction().equals("android.net.wifi.supplicant.CONNECTION_CHANGE") && broadcastIntent.getBooleanExtra("connected", false)) {
            if (serviceScheduler.isScheduled(eventServiceIntent)) {
                context.startService(eventServiceIntent);
                this.logger.info("Preemptively flushing events since wifi became available");
            }
        } else {
            this.logger.warn("Received unsupported broadcast action to event rescheduler");
        }
    }
}

