/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.optimizely.ab.android.event_handler.Event;
import com.optimizely.ab.android.event_handler.EventClient;
import com.optimizely.ab.android.event_handler.EventDAO;
import com.optimizely.ab.android.shared.CountingIdlingResourceManager;
import com.optimizely.ab.android.shared.OptlyStorage;
import com.optimizely.ab.android.shared.ServiceScheduler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

class EventDispatcher {
    @NonNull
    private final Context context;
    @NonNull
    private final ServiceScheduler serviceScheduler;
    @NonNull
    private final EventDAO eventDAO;
    @NonNull
    private final EventClient eventClient;
    @NonNull
    private final Logger logger;
    @NonNull
    private final OptlyStorage optlyStorage;

    EventDispatcher(@NonNull Context context, @NonNull OptlyStorage optlyStorage, @NonNull EventDAO eventDAO, @NonNull EventClient eventClient, @NonNull ServiceScheduler serviceScheduler, @NonNull Logger logger) {
        this.context = context;
        this.optlyStorage = optlyStorage;
        this.eventDAO = eventDAO;
        this.eventClient = eventClient;
        this.serviceScheduler = serviceScheduler;
        this.logger = logger;
    }

    void dispatch(@NonNull Intent intent) {
        boolean dispatched = this.dispatch();
        if (intent.hasExtra("com.optimizely.ab.android.EXTRA_URL")) {
            try {
                String urlExtra = intent.getStringExtra("com.optimizely.ab.android.EXTRA_URL");
                String requestBody = intent.getStringExtra("com.optimizely.ab.android.EXTRA_REQUEST_BODY");
                Event event = new Event(new URL(urlExtra), requestBody);
                dispatched = this.dispatch(event);
            }
            catch (MalformedURLException e) {
                this.logger.error("Received a malformed URL in event handler service", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.warn("Failed to dispatch event.", (Throwable)e);
            }
        }
        try {
            if (!dispatched) {
                long interval = this.getInterval(intent);
                this.serviceScheduler.schedule(intent, interval);
                this.saveInterval(interval);
                this.logger.info("Scheduled events to be dispatched");
            } else {
                this.serviceScheduler.unschedule(intent);
                this.logger.info("Unscheduled event dispatch");
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to schedule event dispatch.", (Throwable)e);
        }
        this.eventDAO.closeDb();
    }

    private long getInterval(@NonNull Intent intent) {
        long duration = intent.getLongExtra("com.optimizely.ab.android.EXTRA_INTERVAL", -1L);
        return duration;
    }

    private void saveInterval(long interval) {
        this.optlyStorage.saveLong("com.optimizely.ab.android.EXTRA_INTERVAL", interval);
    }

    private boolean dispatch() {
        List<Pair<Long, Event>> events = this.eventDAO.getEvents();
        Iterator<Pair<Long, Event>> iterator = events.iterator();
        while (iterator.hasNext()) {
            Pair<Long, Event> event = iterator.next();
            boolean eventWasSent = this.eventClient.sendEvent((Event)event.second);
            if (!eventWasSent) continue;
            iterator.remove();
            boolean eventWasDeleted = this.eventDAO.removeEvent((Long)event.first);
            if (eventWasDeleted) continue;
            this.logger.warn("Unable to delete an event from local storage that was sent to successfully");
        }
        return events.isEmpty();
    }

    private boolean dispatch(Event event) {
        boolean eventWasSent = this.eventClient.sendEvent(event);
        if (eventWasSent) {
            CountingIdlingResourceManager.decrement();
            CountingIdlingResourceManager.recordEvent((Pair)new Pair((Object)event.getURL().toString(), (Object)event.getRequestBody()));
            return true;
        }
        boolean eventWasStored = this.eventDAO.storeEvent(event);
        if (!eventWasStored) {
            this.logger.error("Unable to send or store event {}", (Object)event);
            return true;
        }
        return false;
    }
}

