/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.splashscreen;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Handler;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;

public class SplashScreen
extends CordovaPlugin {
    private static final String LOG_TAG = "SplashScreen";
    private static final boolean HAS_BUILT_IN_SPLASH_SCREEN = Integer.valueOf("5.1.1".split("\\.")[0]) < 4;
    private static Dialog splashDialog;
    private static ProgressDialog spinnerDialog;
    private static boolean firstShow;
    private ImageView splashImageView;
    private int orientation;

    private View getView() {
        try {
            return (View)this.webView.getClass().getMethod("getView", new Class[0]).invoke((Object)this.webView, new Object[0]);
        }
        catch (Exception e) {
            return (View)this.webView;
        }
    }

    @Override
    protected void pluginInitialize() {
        String splashResource;
        if (HAS_BUILT_IN_SPLASH_SCREEN || !firstShow) {
            return;
        }
        this.getView().setVisibility(4);
        int drawableId = this.preferences.getInteger("SplashDrawableId", 0);
        if (drawableId == 0 && (splashResource = this.preferences.getString(LOG_TAG, "screen")) != null) {
            drawableId = this.cordova.getActivity().getResources().getIdentifier(splashResource, "drawable", this.cordova.getActivity().getClass().getPackage().getName());
            if (drawableId == 0) {
                drawableId = this.cordova.getActivity().getResources().getIdentifier(splashResource, "drawable", this.cordova.getActivity().getPackageName());
            }
            this.preferences.set("SplashDrawableId", drawableId);
        }
        this.orientation = this.cordova.getActivity().getResources().getConfiguration().orientation;
        firstShow = false;
        this.loadSpinner();
        this.showSplashScreen(true);
    }

    private boolean isMaintainAspectRatio() {
        return this.preferences.getBoolean("SplashMaintainAspectRatio", false);
    }

    @Override
    public void onPause(boolean multitasking) {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return;
        }
        this.removeSplashScreen();
    }

    @Override
    public void onDestroy() {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return;
        }
        this.removeSplashScreen();
    }

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("hide")) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.webView.postMessage("splashscreen", "hide");
                }
            });
        } else if (action.equals("show")) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.webView.postMessage("splashscreen", "show");
                }
            });
        } else if (action.equals("spinnerStart")) {
            if (!HAS_BUILT_IN_SPLASH_SCREEN) {
                final String title = args.getString(0);
                final String message = args.getString(1);
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.this.spinnerStart(title, message);
                    }
                });
            }
        } else {
            return false;
        }
        callbackContext.success();
        return true;
    }

    @Override
    public Object onMessage(String id2, Object data) {
        if (HAS_BUILT_IN_SPLASH_SCREEN) {
            return null;
        }
        if ("splashscreen".equals(id2)) {
            if ("hide".equals(data.toString())) {
                this.removeSplashScreen();
            } else {
                this.showSplashScreen(false);
            }
        } else if ("spinner".equals(id2)) {
            if ("stop".equals(data.toString())) {
                this.spinnerStop();
                this.getView().setVisibility(0);
            }
        } else if ("onReceivedError".equals(id2)) {
            this.spinnerStop();
        }
        return null;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.orientation != this.orientation) {
            int drawableId;
            this.orientation = newConfig.orientation;
            if (this.splashImageView != null && (drawableId = this.preferences.getInteger("SplashDrawableId", 0)) != 0) {
                this.splashImageView.setImageDrawable(this.cordova.getActivity().getResources().getDrawable(drawableId));
            }
        }
    }

    private void removeSplashScreen() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (splashDialog != null && splashDialog.isShowing()) {
                    splashDialog.dismiss();
                    splashDialog = null;
                    SplashScreen.this.splashImageView = null;
                }
            }
        });
    }

    private void showSplashScreen(final boolean hideAfterDelay) {
        final int splashscreenTime = this.preferences.getInteger("SplashScreenDelay", 3000);
        final int drawableId = this.preferences.getInteger("SplashDrawableId", 0);
        if (splashDialog != null && splashDialog.isShowing()) {
            return;
        }
        if (drawableId == 0 || splashscreenTime <= 0 && hideAfterDelay) {
            return;
        }
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Display display = SplashScreen.this.cordova.getActivity().getWindowManager().getDefaultDisplay();
                Context context = SplashScreen.this.webView.getContext();
                SplashScreen.this.splashImageView = new ImageView(context);
                SplashScreen.this.splashImageView.setImageResource(drawableId);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
                SplashScreen.this.splashImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                SplashScreen.this.splashImageView.setMinimumHeight(display.getHeight());
                SplashScreen.this.splashImageView.setMinimumWidth(display.getWidth());
                SplashScreen.this.splashImageView.setBackgroundColor(SplashScreen.this.preferences.getInteger("backgroundColor", -16777216));
                if (SplashScreen.this.isMaintainAspectRatio()) {
                    SplashScreen.this.splashImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                } else {
                    SplashScreen.this.splashImageView.setScaleType(ImageView.ScaleType.FIT_XY);
                }
                splashDialog = new Dialog(context, 0x1030010);
                if ((SplashScreen.this.cordova.getActivity().getWindow().getAttributes().flags & 0x400) == 1024) {
                    splashDialog.getWindow().setFlags(1024, 1024);
                }
                splashDialog.setContentView((View)SplashScreen.this.splashImageView);
                splashDialog.setCancelable(false);
                splashDialog.show();
                if (hideAfterDelay) {
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SplashScreen.this.removeSplashScreen();
                        }
                    }, (long)splashscreenTime);
                }
            }
        });
    }

    private void loadSpinner() {
        String loading = null;
        loading = this.webView.canGoBack() ? this.preferences.getString("LoadingDialog", null) : this.preferences.getString("LoadingPageDialog", null);
        if (loading != null) {
            String title = "";
            String message = "Loading Application...";
            if (loading.length() > 0) {
                int comma = loading.indexOf(44);
                if (comma > 0) {
                    title = loading.substring(0, comma);
                    message = loading.substring(comma + 1);
                } else {
                    title = "";
                    message = loading;
                }
            }
            this.spinnerStart(title, message);
        }
    }

    private void spinnerStart(final String title, final String message) {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.spinnerStop();
                spinnerDialog = ProgressDialog.show((Context)SplashScreen.this.webView.getContext(), (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        spinnerDialog = null;
                    }
                });
            }
        });
    }

    private void spinnerStop() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (spinnerDialog != null && spinnerDialog.isShowing()) {
                    spinnerDialog.dismiss();
                    spinnerDialog = null;
                }
            }
        });
    }

    static {
        firstShow = true;
    }
}

